/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.openapi;

import io.swagger.v3.oas.integration.ClasspathOpenApiConfigurationLoader;
import io.swagger.v3.oas.integration.FileOpenApiConfigurationLoader;
import io.swagger.v3.oas.integration.api.OpenApiConfigurationLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class OpenApiDefaultConfigurationScanner {
    private static final Map<String, OpenApiConfigurationLoader> LOADERS = OpenApiDefaultConfigurationScanner.getLocationLoaders();
    private static final List<ImmutablePair<String, String>> KNOWN_LOCATIONS = Arrays.asList(new ImmutablePair((Object)"classpath", (Object)"openapi-configuration.yaml"), new ImmutablePair((Object)"classpath", (Object)"openapi-configuration.json"), new ImmutablePair((Object)"classpath", (Object)"openapi.yaml"), new ImmutablePair((Object)"classpath", (Object)"openapi.json"), new ImmutablePair((Object)"file", (Object)"openapi-configuration.yaml"), new ImmutablePair((Object)"file", (Object)"openapi-configuration.json"), new ImmutablePair((Object)"file", (Object)"openapi.yaml"), new ImmutablePair((Object)"file", (Object)"openapi.json"));

    private OpenApiDefaultConfigurationScanner() {
    }

    private static Map<String, OpenApiConfigurationLoader> getLocationLoaders() {
        HashMap<String, OpenApiConfigurationLoader> map = new HashMap<String, OpenApiConfigurationLoader>();
        map.put("classpath", (OpenApiConfigurationLoader)new ClasspathOpenApiConfigurationLoader());
        map.put("file", (OpenApiConfigurationLoader)new FileOpenApiConfigurationLoader());
        return map;
    }

    public static Optional<String> locateDefaultConfiguration() {
        return KNOWN_LOCATIONS.stream().filter(location -> LOADERS.get(location.left).exists((String)location.right)).findFirst().map(Pair::getValue);
    }
}

