/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class PutIndexTemplateRequest
extends MasterNodeRequest<PutIndexTemplateRequest>
implements IndicesRequest,
ToXContentFragment {
    private String name;
    private String cause = "";
    private List<String> indexPatterns;
    private int order;
    private boolean create;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private BytesReference mappings = null;
    private final Set<Alias> aliases = new HashSet<Alias>();
    private Integer version;

    public PutIndexTemplateRequest(String name) {
        this.name(name);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indexPatterns == null || this.indexPatterns.size() == 0) {
            validationException = ValidateActions.addValidationError("index patterns are missing", validationException);
        }
        return validationException;
    }

    public PutIndexTemplateRequest name(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutIndexTemplateRequest patterns(List<String> indexPatterns) {
        this.indexPatterns = indexPatterns;
        return this;
    }

    public List<String> patterns() {
        return this.indexPatterns;
    }

    public PutIndexTemplateRequest order(int order) {
        this.order = order;
        return this;
    }

    public int order() {
        return this.order;
    }

    public PutIndexTemplateRequest version(Integer version) {
        this.version = version;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public PutIndexTemplateRequest create(boolean create) {
        this.create = create;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public PutIndexTemplateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutIndexTemplateRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutIndexTemplateRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public PutIndexTemplateRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(Strings.toString(builder), XContentType.JSON);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public PutIndexTemplateRequest mapping(String source, XContentType xContentType) {
        this.internalMapping(XContentHelper.convertToMap(new BytesArray(source), true, xContentType).v2());
        return this;
    }

    public PutIndexTemplateRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public PutIndexTemplateRequest mapping(XContentBuilder source) {
        this.internalMapping(XContentHelper.convertToMap(BytesReference.bytes(source), true, source.contentType()).v2());
        return this;
    }

    public PutIndexTemplateRequest mapping(BytesReference source, XContentType xContentType) {
        this.internalMapping(XContentHelper.convertToMap(source, true, xContentType).v2());
        return this;
    }

    public PutIndexTemplateRequest mapping(Map<String, Object> source) {
        return this.internalMapping(source);
    }

    private PutIndexTemplateRequest internalMapping(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            Objects.requireNonNull(builder.contentType());
            try {
                this.mappings = new BytesArray(XContentHelper.convertToJson(BytesReference.bytes(builder), false, false, builder.contentType()));
                return this;
            }
            catch (IOException e) {
                throw new UncheckedIOException("failed to convert source to json", e);
            }
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public BytesReference mappings() {
        return this.mappings;
    }

    public PutIndexTemplateRequest source(XContentBuilder templateBuilder) {
        try {
            return this.source(BytesReference.bytes(templateBuilder), templateBuilder.contentType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to build json for template request", e);
        }
    }

    public PutIndexTemplateRequest source(Map<String, Object> templateSource) {
        Map<String, Object> source = templateSource;
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("template")) {
                if (!(entry.getValue() instanceof String)) continue;
                this.patterns(Collections.singletonList((String)entry.getValue()));
                continue;
            }
            if (name.equals("index_patterns")) {
                if (entry.getValue() instanceof String) {
                    this.patterns(Collections.singletonList((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List<String> elements = ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.toList());
                    this.patterns(elements);
                    continue;
                }
                throw new IllegalArgumentException("Malformed [template] value, should be a string or a list of strings");
            }
            if (name.equals("order")) {
                this.order(XContentMapValues.nodeIntegerValue(entry.getValue(), this.order()));
                continue;
            }
            if ("version".equals(name)) {
                if (!(entry.getValue() instanceof Integer)) {
                    throw new IllegalArgumentException("Malformed [version] value, should be an integer");
                }
                this.version((Integer)entry.getValue());
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("Malformed [settings] section, should include an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("mappings")) {
                Map mappings = (Map)entry.getValue();
                this.mapping(mappings);
                continue;
            }
            if (name.equals("aliases")) {
                this.aliases((Map)entry.getValue());
                continue;
            }
            throw new ElasticsearchParseException("unknown key [{}] in the template ", name);
        }
        return this;
    }

    public PutIndexTemplateRequest source(String templateSource, XContentType xContentType) {
        return this.source(XContentHelper.convertToMap(xContentType.xContent(), templateSource, true));
    }

    public PutIndexTemplateRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public PutIndexTemplateRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public PutIndexTemplateRequest source(BytesReference source, XContentType xContentType) {
        return this.source(XContentHelper.convertToMap(source, true, xContentType).v2());
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public PutIndexTemplateRequest aliases(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public PutIndexTemplateRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes(source));
    }

    public PutIndexTemplateRequest aliases(String source) {
        return this.aliases(new BytesArray(source));
    }

    public PutIndexTemplateRequest aliases(BytesReference source) {
        PutIndexTemplateRequest putIndexTemplateRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, source);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent(parser));
                }
                putIndexTemplateRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return putIndexTemplateRequest;
    }

    public PutIndexTemplateRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    @Override
    public String[] indices() {
        return this.indexPatterns.toArray(new String[this.indexPatterns.size()]);
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictExpand();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("index_patterns", this.indexPatterns);
        builder.field("order", this.order);
        if (this.version != null) {
            builder.field("version", this.version);
        }
        builder.startObject("settings");
        this.settings.toXContent(builder, params);
        builder.endObject();
        if (this.mappings != null) {
            builder.field("mappings");
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, this.mappings.utf8ToString());){
                builder.copyCurrentStructure(parser);
            }
        }
        builder.startObject("aliases");
        for (Alias alias : this.aliases) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

