/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

public class MetaServiceCaller {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withMetaTypeService(BundleContext context, Function<MetaTypeService, T> callable) {
        ServiceReference ref = context.getServiceReference(MetaTypeService.class);
        if (ref != null) {
            try {
                MetaTypeService metaService = (MetaTypeService)context.getService(ref);
                T t = callable.apply(metaService);
                return t;
            }
            finally {
                context.ungetService(ref);
            }
        }
        return null;
    }

    public static List<String> getPidsWithMetaInfo(BundleContext context) {
        return MetaServiceCaller.withMetaTypeService(context, metatypeService -> {
            ArrayList<String> pids1 = new ArrayList<String>();
            Bundle[] bundles = context.getBundles();
            if (metatypeService != null) {
                for (Bundle bundle : bundles) {
                    MetaTypeInformation info = metatypeService.getMetaTypeInformation(bundle);
                    if (info == null) continue;
                    if (info.getFactoryPids() != null) {
                        pids1.addAll(Arrays.asList(info.getFactoryPids()));
                    }
                    if (info.getPids() == null) continue;
                    pids1.addAll(Arrays.asList(info.getPids()));
                }
            }
            return pids1;
        });
    }
}

