/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.Member;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.karaf.cellar.core.Node;

public class HazelcastNode
implements Node {
    private String id;
    private String host;
    private int port;
    private transient String alias;

    public HazelcastNode(Member member) {
        InetSocketAddress address = member.getSocketAddress();
        this.host = HazelcastNode.getHostString(address);
        this.port = address.getPort();
        StringBuilder builder = new StringBuilder();
        this.id = builder.append(this.host).append(":").append(this.port).toString();
        this.alias = member.getStringAttribute("alias");
    }

    static String getHostString(InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        return address != null && address.toString().startsWith("/") ? address.getHostAddress() : socketAddress.getHostName();
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HazelcastNode that = (HazelcastNode)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "HazelcastNode [id=" + this.id + ", host=" + this.host + ", port=" + this.port + "]";
    }
}

