/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.model;

import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSectionParm;

public class ConfigGroup {
    private ConfigurationParameterDeclarations cpd;
    private int kind;
    private ConfigurationGroup namedCg = null;
    public static final int NOT_IN_ANY_GROUP = 1;
    public static final int COMMON = 2;
    public static final int NAMED_GROUP = 4;

    public ConfigGroup(ConfigurationParameterDeclarations aCpd, int aKind) {
        this.cpd = aCpd;
        this.kind = aKind;
        this.fixupCpd();
    }

    public ConfigGroup(ConfigurationParameterDeclarations aCpd, ConfigurationGroup aNamedCg) {
        this.cpd = aCpd;
        this.kind = 4;
        this.namedCg = aNamedCg;
        this.fixupCpd();
    }

    private void fixupCpd() {
        if (null == this.cpd.getConfigurationParameters()) {
            this.cpd.setConfigurationParameters(AbstractSection.configurationParameterArray0);
        }
        if (null == this.cpd.getCommonParameters()) {
            this.cpd.setCommonParameters(AbstractSection.configurationParameterArray0);
        }
        if (null == this.cpd.getConfigurationGroups()) {
            this.cpd.setConfigurationGroups(AbstractSection.configurationGroupArray0);
        }
        ConfigurationGroup[] cgs = this.cpd.getConfigurationGroups();
        for (int i = 0; i < cgs.length; ++i) {
            if (null != cgs[i].getConfigurationParameters()) continue;
            cgs[i].setConfigurationParameters(AbstractSection.configurationParameterArray0);
        }
    }

    public ConfigurationParameter[] getConfigParms() {
        switch (this.kind) {
            case 1: {
                return this.cpd.getConfigurationParameters();
            }
            case 2: {
                return this.cpd.getCommonParameters();
            }
            case 4: {
                return this.namedCg.getConfigurationParameters();
            }
        }
        throw new InternalErrorCDE("invalid state");
    }

    public String getName() {
        switch (this.kind) {
            case 1: {
                return AbstractSectionParm.NOT_IN_ANY_GROUP;
            }
            case 2: {
                return AbstractSectionParm.COMMON_GROUP;
            }
            case 4: {
                return AbstractSectionParm.groupNameArrayToString(this.namedCg.getNames());
            }
        }
        throw new InternalErrorCDE("invalid state");
    }

    public String[] getNameArray() {
        switch (this.kind) {
            case 1: {
                return new String[]{AbstractSectionParm.NOT_IN_ANY_GROUP};
            }
            case 2: {
                return new String[]{AbstractSectionParm.COMMON_GROUP};
            }
            case 4: {
                return this.namedCg.getNames();
            }
        }
        throw new InternalErrorCDE("invalid state");
    }

    public void setNameArray(String[] names) {
        if (this.kind != 4) {
            throw new InternalErrorCDE("invalid call");
        }
        this.namedCg.setNames(names);
    }

    public int getKind() {
        return this.kind;
    }

    public ConfigurationParameterDeclarations getCPD() {
        return this.cpd;
    }
}

