/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.util;

public class Span
implements Comparable<Span> {
    private int mStart;
    private int mLength;

    public Span(int start, int length) {
        this.mStart = start;
        this.mLength = length;
    }

    public int getStart() {
        return this.mStart;
    }

    public int getLength() {
        return this.mLength;
    }

    public int getEnd() {
        return this.mStart + this.mLength;
    }

    public boolean isContaining(Span containingSpan) {
        boolean isEndContaining;
        boolean isStartContaining;
        boolean bl = isStartContaining = this.getStart() <= containingSpan.getStart();
        if (!isStartContaining) {
            return false;
        }
        boolean bl2 = isEndContaining = this.getEnd() >= containingSpan.getEnd();
        return isEndContaining;
    }

    public boolean isIntersecting(Span s) {
        int sstart = s.getStart();
        return this.isContaining(s) || s.isContaining(this) || this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s.getEnd();
    }

    @Override
    public int compareTo(Span span) {
        return span.getStart() - this.getStart();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Span)) {
            return false;
        }
        Span span = (Span)o;
        if (this.getStart() != span.getStart()) {
            return false;
        }
        return this.getLength() == span.getLength();
    }

    public String toString() {
        return "Span: " + this.getStart() + "-" + this.getEnd() + " Length: " + this.getLength();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

