/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.insd.edit;

import java.util.Hashtable;
import org.apache.uima.pear.PearException;
import org.apache.uima.pear.insd.edit.InsdConstants;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class INSDComponentPage
extends WizardPage
implements InsdConstants {
    InstallationDescriptor insd;
    private Group gr;
    public String compID = "";
    public String compDescriptorPath = "";
    public String compType = "analysis_engine";
    private Text compIDText;
    private Text compDescriptorPathText;
    IContainer currentContainer;
    Hashtable wizardData;

    public INSDComponentPage(IContainer currentContainer, InstallationDescriptor insd, Hashtable wizardData) {
        super("wizardPage");
        this.setTitle("UIMA - Installation Descriptor - Component Information");
        this.setDescription("Enter information about your UIMA component. The required fields are indicated with a (*).\nThe descriptor must be specified using paths relative to the project's root (e.g. \"desc/MyTAE.xml\").\n");
        this.wizardData = wizardData;
        this.insd = insd;
        this.currentContainer = currentContainer;
        try {
            this.initializePage();
            this.validateCompInfo();
        }
        catch (Throwable e) {
            PearException subEx = new PearException("The operation failed because the wizard's pages could not be initialized properly.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
    }

    public static String removeMacros(String s) {
        s = s.replaceFirst("\\$main_root\\./", "");
        s = s.replaceFirst("\\$main_root\\.\\\\", "");
        s = s.replaceFirst("\\$main_root/", "");
        s = s.replaceFirst("\\$main_root\\\\", "");
        s = s.replaceFirst("\\$main_root", "");
        return s;
    }

    void initializePage() {
        String temp = "";
        temp = this.insd.getMainComponentId();
        this.compID = temp == null || temp.trim().length() == 0 ? this.currentContainer.getName() : temp;
        temp = this.insd.getMainComponentDesc();
        this.compDescriptorPath = temp == null ? "" : INSDComponentPage.removeMacros(temp);
    }

    public Text addTextField(Composite parent, String strLabel, String strText, boolean editable) {
        Label label = new Label(parent, 0);
        label.setText(strLabel);
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setText(strText);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                INSDComponentPage.this.dialogChanged();
            }
        });
        text.setEditable(editable);
        return text;
    }

    public void createControl(Composite parent) {
        try {
            Composite container = new Composite(parent, 0);
            FormLayout formLayout = new FormLayout();
            container.setLayout((Layout)formLayout);
            this.gr = new Group(container, 0);
            this.gr.setText("Component Information");
            FormData data = new FormData();
            data.width = 450;
            data.left = new FormAttachment(0, 10);
            this.gr.setLayoutData((Object)data);
            GridLayout grLayout = new GridLayout();
            grLayout.numColumns = 3;
            grLayout.verticalSpacing = 4;
            this.gr.setLayout((Layout)grLayout);
            this.compIDText = this.addTextField((Composite)this.gr, "&Component ID*:", this.compID, true);
            Label compIDLabel = new Label((Composite)this.gr, 0);
            compIDLabel.setText(" ");
            this.compDescriptorPathText = this.addTextField((Composite)this.gr, "&Component Descriptor*:         ", this.compDescriptorPath, true);
            this.addButton((Composite)this.gr, "   &Browse...   ", true, this.compDescriptorPathText);
            String fileValidationMsg = this.validateFiles();
            this.setErrorMessage(fileValidationMsg);
            this.dialogChanged();
            this.setControl((Control)container);
        }
        catch (Throwable e) {
            PearException subEx = new PearException("The operation failed because the wizard's pages could not be initialized properly.", e);
            subEx.openErrorDialog(this.getShell());
            this.dispose();
        }
    }

    private void dialogChanged() {
        this.compID = this.compIDText.getText();
        System.out.println("compID: " + this.compID);
        this.compDescriptorPath = this.compDescriptorPathText.getText();
        System.out.println("compDescriptorPath: " + this.compDescriptorPath);
        this.insd.setMainComponentDesc(this.compDescriptorPath);
        this.saveWizardData();
        if (this.compID == null || this.compID.trim().length() == 0 || this.compDescriptorPath == null || this.compDescriptorPath.trim().length() == 0) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
        } else {
            this.updateStatus(null);
        }
    }

    void validateCompInfo() {
        if (this.compID == null || this.compID.trim().length() == 0 || this.compDescriptorPath == null || this.compDescriptorPath.trim().length() == 0) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
        } else {
            this.updateStatus(null);
        }
    }

    void saveWizardData() {
        this.wizardData.put("compDescriptorPath", this.compDescriptorPath);
    }

    private void updateStatus(String message) {
        if (message == null) {
            String fileValidationMsg = this.validateFiles();
            this.setErrorMessage(fileValidationMsg);
            this.setPageComplete(fileValidationMsg == null);
        } else {
            this.setErrorMessage(message);
            this.setPageComplete(false);
        }
    }

    private String validateFiles() {
        String message = null;
        StringBuffer sb = new StringBuffer();
        String[] files = new String[]{this.compDescriptorPath};
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i];
            if (filename == null || filename.trim().length() <= 0) continue;
            IFile iFile = this.currentContainer.getFile((IPath)new Path(filename = filename.trim()));
            if (!iFile.exists()) {
                sb.append("\n  \"" + filename + "\" was not found in the current project!");
                continue;
            }
            if (filename.trim().indexOf(".xml") != -1) continue;
            sb.append("\n  \"" + filename + "\" is not an xml file!");
        }
        String s = sb.toString();
        if (s.length() > 0) {
            message = s;
        }
        return message;
    }

    protected Button addButton(Composite parent, String label, boolean defaultButton, final Text text) {
        Button button = new Button(parent, 8);
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(parent.getFont());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceSelectionDialog dialog = new ResourceSelectionDialog(INSDComponentPage.this.getShell(), (IAdaptable)INSDComponentPage.this.currentContainer, "Selection Dialog");
                dialog.setTitle("Selection Dialog");
                dialog.setMessage("Please select a file:");
                dialog.open();
                Object[] result = dialog.getResult();
                if (result[0] != null) {
                    IResource res = (IResource)result[0];
                    text.setText(res.getProjectRelativePath().toOSString());
                }
            }
        };
        button.addSelectionListener((SelectionListener)listener);
        return button;
    }

    protected Button addRadioButton(Composite parent, String label, boolean initialSelection) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setFont(parent.getFont());
        button.setSelection(initialSelection);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                INSDComponentPage.this.dialogChanged();
            }
        };
        button.addSelectionListener((SelectionListener)listener);
        return button;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.compIDText.setFocus();
        }
    }
}

