/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.documentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ruta.ide.RutaIdePlugin;
import org.apache.uima.ruta.ide.ui.documentation.HtmlDocumentationVisitor;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.htmlparser.Parser;
import org.htmlparser.util.NodeList;
import org.htmlparser.visitors.NodeVisitor;

public abstract class AbstractLanguageElementDocumentationProvider
implements IScriptDocumentationProvider {
    protected Map<String, String> map = new HashMap<String, String>();

    public AbstractLanguageElementDocumentationProvider(String file) {
        if (file != null) {
            try {
                this.fillMap(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Reader getInfo(String content) {
        String string = this.map.get(content);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        return null;
    }

    private void fillMap(String documentationFile) throws IOException {
        String line;
        InputStream resourceAsStream = this.getClass().getResourceAsStream(documentationFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n");
        }
        String document = sb.toString();
        try {
            Parser parser = new Parser(document);
            NodeList list = parser.parse(null);
            HtmlDocumentationVisitor visitor = new HtmlDocumentationVisitor(document);
            list.visitAllNodesWith((NodeVisitor)visitor);
            this.map.putAll(visitor.getMap());
        }
        catch (Exception e) {
            RutaIdePlugin.error(e);
        }
    }
}

