/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.list.BooleanListExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.list.NumberListExpression;
import org.apache.uima.ruta.expression.list.StringListExpression;
import org.apache.uima.ruta.expression.list.TypeListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class CountCondition
extends TypeSentiveCondition {
    private final NumberExpression min;
    private final NumberExpression max;
    private final String var;
    private ListExpression list;
    private RutaExpression arg;

    public CountCondition(TypeExpression type, NumberExpression min, NumberExpression max, String var) {
        super(type);
        this.min = min == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    public CountCondition(ListExpression list, RutaExpression a, NumberExpression min, NumberExpression max, String var) {
        super((TypeExpression)null);
        this.list = list;
        this.arg = a;
        this.min = min == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        StringExpression e;
        if (this.arg == null) {
            List<AnnotationFS> annotationsInWindow = stream.getAnnotationsInWindow(annotation, this.type.getType(element.getParent()));
            int count = annotationsInWindow.size();
            if (this.var != null) {
                element.getParent().getEnvironment().setVariableValue(this.var, count);
            }
            boolean value = count >= this.min.getIntegerValue(element.getParent()) && count <= this.max.getIntegerValue(element.getParent());
            return new EvaluatedCondition(this, value);
        }
        int count = 0;
        if (this.arg instanceof BooleanExpression && this.list instanceof BooleanListExpression) {
            e = (BooleanExpression)this.arg;
            BooleanListExpression le = (BooleanListExpression)this.list;
            boolean v = ((BooleanExpression)e).getBooleanValue(element.getParent());
            ArrayList l = new ArrayList(le.getList(element.getParent()));
            while (l.remove(v)) {
                ++count;
            }
        } else if (this.arg instanceof NumberExpression && this.list instanceof NumberListExpression) {
            e = (NumberExpression)this.arg;
            NumberListExpression le = (NumberListExpression)this.list;
            Double v = ((NumberExpression)e).getDoubleValue(element.getParent());
            ArrayList l = new ArrayList(le.getList(element.getParent()));
            while (l.remove(v)) {
                ++count;
            }
        } else if (this.arg instanceof StringExpression && this.list instanceof StringListExpression) {
            e = (StringExpression)this.arg;
            StringListExpression le = (StringListExpression)this.list;
            String v = e.getStringValue(element.getParent());
            ArrayList l = new ArrayList(le.getList(element.getParent()));
            while (l.remove(v)) {
                ++count;
            }
        } else if (this.arg instanceof TypeExpression && this.list instanceof TypeListExpression) {
            e = (TypeExpression)this.arg;
            TypeListExpression le = (TypeListExpression)this.list;
            Type v = ((TypeExpression)e).getType(element.getParent());
            ArrayList l = new ArrayList(le.getList(element.getParent()));
            while (l.remove(v)) {
                ++count;
            }
        }
        if (this.var != null) {
            element.getParent().getEnvironment().setVariableValue(this.var, count);
        }
        boolean value = count >= this.min.getIntegerValue(element.getParent()) && count <= this.max.getIntegerValue(element.getParent());
        return new EvaluatedCondition(this, value);
    }

    public NumberExpression getMin() {
        return this.min;
    }

    public NumberExpression getMax() {
        return this.max;
    }

    public String getVar() {
        return this.var;
    }

    public ListExpression getArgList() {
        return this.list;
    }

    public RutaExpression getArg() {
        return this.arg;
    }
}

