/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.MarkAction;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOnceAction
extends MarkAction {
    public MarkOnceAction(TypeExpression type, NumberExpression scoreValue, List<NumberExpression> list) {
        super(type, scoreValue, list);
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<Integer> indexList = this.getIndexList(element, this.list);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(stream, indexList, element.getContainer());
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            CAS cas = stream.getCas();
            if (matchedAnnotation == null) {
                return;
            }
            Type t = this.type.getType(element.getParent());
            AnnotationFS createAnnotation = cas.createAnnotation(t, matchedAnnotation.getBegin(), matchedAnnotation.getEnd());
            boolean contains = false;
            FSIterator iterator = cas.getAnnotationIndex(t).iterator((FeatureStructure)createAnnotation);
            while (iterator.isValid() && ((AnnotationFS)iterator.get()).getEnd() == createAnnotation.getEnd()) {
                AnnotationFS a = (AnnotationFS)iterator.get();
                if (a.getBegin() == createAnnotation.getBegin() && a.getEnd() == createAnnotation.getEnd() && a.getType().getName().equals(createAnnotation.getType().getName())) {
                    contains = true;
                    break;
                }
                iterator.moveToNext();
            }
            if (contains) continue;
            super.execute(match, element, stream, crowd);
        }
    }
}

