/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SequencedCollection;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.ruta.FilterManager;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.AnnotationComparator;
import org.apache.uima.ruta.type.RutaAnnotation;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaStream
extends FSIteratorImplBase<AnnotationFS> {
    private final CAS cas;
    private FSIterator<AnnotationFS> basicIt;
    private FSIterator<AnnotationFS> currentIt;
    private AnnotationFS documentAnnotation;
    private Type documentAnnotationType;
    private Type basicType;
    private final TreeSet<RutaBasic> basics;
    private TreeMap<Integer, RutaBasic> beginAnchors;
    private TreeMap<Integer, RutaBasic> endAnchors;
    private FilterManager filter;
    private boolean dynamicAnchoring;
    private double indexPenalty = 5.0;
    private double anchoringFactor;
    private boolean lowMemoryProfile;
    private boolean simpleGreedyForComposed;
    private InferenceCrowd crowd;

    protected RutaStream(CAS cas, FSIterator<AnnotationFS> current, Type basicType, FilterManager filter, boolean lowMemoryProfile, boolean simpleGreedyForComposed, InferenceCrowd crowd) {
        this.cas = cas;
        this.filter = filter;
        this.basicType = basicType;
        this.lowMemoryProfile = lowMemoryProfile;
        this.simpleGreedyForComposed = simpleGreedyForComposed;
        this.crowd = crowd;
        AnnotationFS additionalWindow = filter.getWindowAnnotation();
        this.updateIterators(cas, basicType, filter, additionalWindow);
        if (additionalWindow == null) {
            this.documentAnnotation = (DocumentAnnotation)this.getJCas().getDocumentAnnotationFs();
            this.documentAnnotationType = this.getCas().getDocumentAnnotation().getType();
            this.basicIt.moveToFirst();
        } else {
            this.documentAnnotation = additionalWindow;
            this.documentAnnotationType = filter.getWindowType();
        }
        AnnotationComparator comparator = new AnnotationComparator();
        this.basics = new TreeSet<AnnotationFS>(comparator);
        this.beginAnchors = new TreeMap();
        this.endAnchors = new TreeMap();
        FSIterator iterator = cas.getAnnotationIndex(basicType).subiterator(this.documentAnnotation);
        while (iterator.isValid()) {
            RutaBasic e = (RutaBasic)iterator.get();
            this.beginAnchors.put(e.getBegin(), e);
            this.endAnchors.put(e.getEnd(), e);
            this.basics.add(e);
            iterator.moveToNext();
        }
    }

    private void updateIterators(AnnotationFS additionalWindow) {
        this.updateIterators(this.cas, this.basicType, this.filter, additionalWindow);
    }

    private void updateIterators(CAS cas, Type basicType, FilterManager filter, AnnotationFS additionalWindow) {
        this.basicIt = additionalWindow != null ? cas.getAnnotationIndex(basicType).subiterator(additionalWindow) : cas.getAnnotationIndex(basicType).iterator();
        this.currentIt = filter.createFilteredIterator(cas, basicType);
    }

    public RutaStream(CAS cas, Type basicType, FilterManager filter, boolean lowMemoryProfile, boolean simpleGreedyForComposed, InferenceCrowd crowd) {
        this(cas, null, basicType, filter, lowMemoryProfile, simpleGreedyForComposed, crowd);
    }

    public void initalizeBasics() {
        AnnotationIndex basicIndex = this.cas.getAnnotationIndex(this.basicType);
        AnnotationIndex annotationIndex = this.cas.getAnnotationIndex();
        LinkedList<AnnotationFS> allAnnotations = new LinkedList<AnnotationFS>();
        for (AnnotationFS a : annotationIndex) {
            allAnnotations.add(a);
        }
        if (basicIndex.size() == 0) {
            Integer first;
            TreeSet<Integer> anchors = new TreeSet<Integer>();
            for (AnnotationFS a : allAnnotations) {
                anchors.add(a.getBegin());
                anchors.add(a.getEnd());
            }
            if (anchors.size() == 1) {
                first = (Integer)anchors.first();
                anchors.remove(first);
                RutaBasic newTMB = new RutaBasic(this.getJCas(), first, first);
                newTMB.setLowMemoryProfile(this.lowMemoryProfile);
                this.beginAnchors.put(first, newTMB);
                this.endAnchors.put(first, newTMB);
                this.basics.add(newTMB);
                this.cas.addFsToIndexes((FeatureStructure)newTMB);
            } else {
                while (anchors.size() >= 2) {
                    first = (Integer)anchors.first();
                    anchors.remove(first);
                    Integer second = (Integer)anchors.first();
                    RutaBasic newTMB = new RutaBasic(this.getJCas(), first, second);
                    newTMB.setLowMemoryProfile(this.lowMemoryProfile);
                    this.beginAnchors.put(first, newTMB);
                    this.endAnchors.put(second, newTMB);
                    this.basics.add(newTMB);
                    this.cas.addFsToIndexes((FeatureStructure)newTMB);
                }
            }
        }
        for (AnnotationFS a : allAnnotations) {
            if (a.getType().equals(this.basicType)) continue;
            this.addAnnotation(a, false, false, null);
        }
        this.updateIterators(this.documentAnnotation);
    }

    public void addAnnotation(AnnotationFS annotation, boolean addToIndex, AbstractRuleMatch<? extends AbstractRule> creator) {
        if (addToIndex) {
            this.cas.addFsToIndexes((FeatureStructure)annotation);
        }
        this.addAnnotation(annotation, creator);
    }

    public void addAnnotation(AnnotationFS annotation, AbstractRuleMatch<? extends AbstractRule> creator) {
        this.addAnnotation(annotation, false, true, creator);
    }

    public void addAnnotation(AnnotationFS annotation, boolean addToIndex, boolean updateInternal, AbstractRuleMatch<? extends AbstractRule> creator) {
        Type type = annotation.getType();
        boolean modified = this.checkSpan(annotation);
        if (modified && updateInternal) {
            this.updateIterators(this.filter.getWindowAnnotation());
        }
        RutaBasic beginAnchor = this.getBeginAnchor(annotation.getBegin());
        RutaBasic endAnchor = this.getEndAnchor(annotation.getEnd());
        beginAnchor.addBegin(annotation, type);
        if (endAnchor != null) {
            endAnchor.addEnd(annotation, type);
        }
        Collection<RutaBasic> basicAnnotationsInWindow = this.getAllBasicsInWindow(annotation);
        for (RutaBasic basic : basicAnnotationsInWindow) {
            basic.addPartOf(type);
        }
        if (addToIndex) {
            this.cas.addFsToIndexes((FeatureStructure)annotation);
        }
        this.crowd.annotationAdded(annotation, creator);
    }

    private boolean checkSpan(AnnotationFS annotation) {
        boolean result = false;
        int begin = annotation.getBegin();
        int end = annotation.getEnd();
        RutaBasic beginAnchor = this.getBeginAnchor(begin);
        RutaBasic endAnchor = this.getEndAnchor(end);
        if (beginAnchor != null && endAnchor != null) {
            result = false;
        } else {
            if (beginAnchor == null) {
                result |= this.checkAnchor(begin);
            }
            if (endAnchor == null) {
                result |= this.checkAnchor(end);
            }
        }
        return result;
    }

    private boolean checkAnchor(int anchor) {
        RutaBasic floor = this.getFloor(this.endAnchors, anchor);
        if (floor == null) {
            floor = this.getFloor(this.beginAnchors, anchor);
        }
        RutaBasic ceiling = this.getCeiling(this.endAnchors, anchor);
        if (floor != null && ceiling != null) {
            RutaBasic toSplit = null;
            toSplit = floor.getEnd() > anchor ? floor : ceiling;
            int newEnd = toSplit.getEnd();
            this.cas.removeFsFromIndexes((FeatureStructure)toSplit);
            toSplit.setEnd(anchor);
            RutaBasic newTMB = new RutaBasic(this.getJCas(), anchor, newEnd);
            this.cas.addFsToIndexes((FeatureStructure)toSplit);
            this.cas.addFsToIndexes((FeatureStructure)newTMB);
            this.beginAnchors.put(floor.getBegin(), floor);
            this.beginAnchors.put(newTMB.getBegin(), newTMB);
            this.beginAnchors.put(ceiling.getBegin(), ceiling);
            this.endAnchors.put(floor.getEnd(), floor);
            this.endAnchors.put(newTMB.getEnd(), newTMB);
            this.endAnchors.put(ceiling.getEnd(), ceiling);
            return true;
        }
        return false;
    }

    private RutaBasic getCeiling(TreeMap<Integer, RutaBasic> anchors, int anchor) {
        RutaBasic basic = anchors.get(anchor);
        if (basic != null) {
            return basic;
        }
        if (anchor <= anchors.lastKey()) {
            return this.getCeiling(anchors, ++anchor);
        }
        return null;
    }

    private RutaBasic getFloor(TreeMap<Integer, RutaBasic> anchors, int anchor) {
        RutaBasic basic = anchors.get(anchor);
        if (basic != null) {
            return basic;
        }
        if (anchor >= 0) {
            return this.getFloor(anchors, --anchor);
        }
        return null;
    }

    public void removeAnnotation(AnnotationFS annotationFS) {
        this.removeAnnotation(annotationFS, annotationFS.getType());
    }

    public void removeAnnotation(AnnotationFS annotation, Type type) {
        Collection<RutaBasic> basicAnnotationsInWindow = this.getAllBasicsInWindow(annotation);
        for (RutaBasic basic : basicAnnotationsInWindow) {
            basic.removePartOf(type);
        }
        Type parent = type;
        RutaBasic beginAnchor = this.getBeginAnchor(annotation.getBegin());
        RutaBasic endAnchor = this.getEndAnchor(annotation.getEnd());
        beginAnchor.removeBegin(annotation, parent);
        endAnchor.removeEnd(annotation, parent);
        if (!(annotation instanceof RutaBasic)) {
            this.cas.removeFsFromIndexes((FeatureStructure)annotation);
        }
    }

    public FSIterator<AnnotationFS> getFilteredBasicIterator(FSMatchConstraint constraint) {
        ConstraintFactory cf = this.cas.getConstraintFactory();
        FSMatchConstraint matchConstraint = cf.and(constraint, this.filter.getDefaultConstraint());
        return this.cas.createFilteredIterator(this.basicIt, matchConstraint);
    }

    public RutaStream getWindowStream(AnnotationFS windowAnnotation, Type windowType) {
        if (windowAnnotation.getBegin() == this.documentAnnotation.getBegin() && windowAnnotation.getEnd() == this.documentAnnotation.getEnd()) {
            return this;
        }
        FilterManager filterManager = new FilterManager(this.filter.getDefaultFilterTypes(), this.filter.getCurrentFilterTypes(), this.filter.getCurrentRetainTypes(), windowAnnotation, windowType, this.cas);
        RutaStream stream = new RutaStream(this.cas, this.basicIt, this.basicType, filterManager, this.lowMemoryProfile, this.simpleGreedyForComposed, this.crowd);
        return stream;
    }

    public FSIterator<AnnotationFS> copy() {
        return new RutaStream(this.cas, (FSIterator<AnnotationFS>)this.currentIt.copy(), this.basicType, this.filter, this.lowMemoryProfile, this.simpleGreedyForComposed, this.crowd);
    }

    public AnnotationFS get() throws NoSuchElementException {
        return (AnnotationFS)this.currentIt.get();
    }

    public boolean isValid() {
        return this.currentIt.isValid();
    }

    public void moveTo(FeatureStructure fs) {
        try {
            this.currentIt.moveTo(fs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveToFirst() {
        this.currentIt.moveToFirst();
    }

    public void moveToLast() {
        this.currentIt.moveToLast();
    }

    public void moveToNext() {
        this.currentIt.moveToNext();
    }

    public void moveToPrevious() {
        this.currentIt.moveToPrevious();
    }

    public List<AnnotationFS> getOverappingAnnotations(AnnotationFS window, Type type) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        AnnotationFS newWindow = this.cas.createAnnotation(type, window.getBegin(), window.getEnd() - 1);
        FSIterator iterator = this.cas.getAnnotationIndex(type).iterator((FeatureStructure)newWindow);
        if (!iterator.isValid()) {
            iterator.moveToLast();
        }
        while (iterator.isValid()) {
            AnnotationFS a;
            FeatureStructure fs = iterator.get();
            if (fs instanceof AnnotationFS && (a = (AnnotationFS)fs).getEnd() >= window.getEnd() && a.getBegin() <= window.getBegin()) {
                result.add(a);
            }
            iterator.moveToPrevious();
        }
        return result;
    }

    public List<Annotation> getAnnotationsFollowing(Annotation annotation) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        this.moveTo((FeatureStructure)annotation);
        while (this.currentIt.isValid()) {
            this.currentIt.moveToNext();
            if (!this.currentIt.isValid()) continue;
            Annotation nextAnnotation = (Annotation)this.currentIt.get();
            if (nextAnnotation.getBegin() == annotation.getEnd()) {
                result.add(nextAnnotation);
                continue;
            }
            if (nextAnnotation.getBegin() < annotation.getEnd()) continue;
            break;
        }
        return result;
    }

    public CAS getCas() {
        return this.cas;
    }

    public JCas getJCas() {
        try {
            return this.cas.getJCas();
        }
        catch (CASException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<AnnotationFS> getAllofType(Type type) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        FSIterator iterator = this.cas.getAnnotationIndex(type).iterator();
        while (iterator.isValid()) {
            FeatureStructure featureStructure = iterator.get();
            result.add((AnnotationFS)featureStructure);
            iterator.moveToNext();
        }
        return result;
    }

    public List<AnnotationFS> getAnnotationsInWindow2(AnnotationFS windowAnnotation, Type type) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        windowAnnotation = this.cas.createAnnotation(type, windowAnnotation.getBegin(), windowAnnotation.getEnd() + 1);
        FSIterator completeIt = this.getCas().getAnnotationIndex(type).iterator();
        if (this.getDocumentAnnotation().getEnd() < windowAnnotation.getEnd()) {
            completeIt.moveToLast();
        } else {
            completeIt.moveTo((FeatureStructure)windowAnnotation);
        }
        while (completeIt.isValid() && ((Annotation)completeIt.get()).getBegin() >= windowAnnotation.getBegin()) {
            completeIt.moveToPrevious();
        }
        if (completeIt.isValid()) {
            completeIt.moveToNext();
        } else {
            completeIt.moveToFirst();
        }
        while (completeIt.isValid() && ((Annotation)completeIt.get()).getBegin() < windowAnnotation.getBegin()) {
            completeIt.moveToNext();
        }
        while (completeIt.isValid() && ((Annotation)completeIt.get()).getBegin() >= windowAnnotation.getBegin()) {
            Annotation annotation = (Annotation)completeIt.get();
            if (this.getCas().getTypeSystem().subsumes(type, annotation.getType()) && annotation.getEnd() <= windowAnnotation.getEnd()) {
                result.add((AnnotationFS)annotation);
            }
            completeIt.moveToNext();
        }
        return result;
    }

    public List<AnnotationFS> getAnnotationsInWindow(AnnotationFS windowAnnotation, Type type) {
        ArrayList<AnnotationFS> result = new ArrayList();
        List<AnnotationFS> inWindow = this.getAnnotationsInWindow2(windowAnnotation, type);
        result = inWindow;
        return result;
    }

    public Collection<RutaBasic> getAllBasicsInWindow(AnnotationFS windowAnnotation) {
        if (windowAnnotation.getBegin() >= windowAnnotation.getEnd()) {
            return Collections.emptySet();
        }
        RutaBasic beginAnchor = this.getBeginAnchor(windowAnnotation.getBegin());
        if (beginAnchor.getEnd() == windowAnnotation.getEnd()) {
            ArrayList<RutaBasic> result = new ArrayList<RutaBasic>(1);
            result.add(beginAnchor);
            return result;
        }
        SequencedCollection<RutaBasic> subSet = null;
        if (windowAnnotation.getEnd() == this.cas.getDocumentAnnotation().getEnd() && windowAnnotation.getBegin() == 0) {
            subSet = this.basics;
        } else if (windowAnnotation.getEnd() == this.cas.getDocumentAnnotation().getEnd()) {
            subSet = this.basics.tailSet(beginAnchor);
        } else {
            RutaBasic endAnchor1 = this.getCeiling(this.endAnchors, windowAnnotation.getEnd() + 1);
            if (endAnchor1 != null) {
                subSet = this.basics.subSet(beginAnchor, endAnchor1);
            } else {
                subSet = new LinkedList();
                RutaBasic floor = this.getFloor(this.endAnchors, windowAnnotation.getEnd());
                SortedSet<RutaBasic> subSetHead = this.basics.subSet(beginAnchor, floor);
                RutaBasic endAnchorTail = this.endAnchors.get(windowAnnotation.getEnd());
                subSet.addAll(subSetHead);
                subSet.add(endAnchorTail);
            }
        }
        return subSet;
    }

    public RutaBasic getBasicNextTo(boolean before, AnnotationFS annotation) {
        if (annotation == null) {
            return this.beginAnchors.get(0);
        }
        if (before) {
            RutaBasic pointer = this.beginAnchors.get(annotation.getBegin());
            this.moveTo((FeatureStructure)pointer);
            if (this.isVisible((AnnotationFS)pointer)) {
                this.moveToPrevious();
            }
            if (this.isValid()) {
                return (RutaBasic)this.get();
            }
        } else {
            RutaBasic pointer = this.endAnchors.get(annotation.getEnd());
            this.moveTo((FeatureStructure)pointer);
            if (this.isVisible((AnnotationFS)pointer)) {
                this.moveToNext();
            }
            if (this.isValid()) {
                return (RutaBasic)this.get();
            }
        }
        return null;
    }

    public List<RutaBasic> getBasicsInWindow(AnnotationFS windowAnnotation) {
        ArrayList<RutaBasic> result = new ArrayList<RutaBasic>();
        if (windowAnnotation instanceof RutaBasic) {
            result.add((RutaBasic)windowAnnotation);
            return result;
        }
        FSMatchConstraint defaultConstraint = this.filter.getDefaultConstraint();
        FSIterator iterator = this.cas.createFilteredIterator(this.cas.getAnnotationIndex(this.basicType).subiterator(windowAnnotation), defaultConstraint);
        while (iterator.isValid()) {
            result.add((RutaBasic)iterator.get());
            iterator.moveToNext();
        }
        return result;
    }

    public RutaBasic getFirstBasicInWindow(AnnotationFS windowAnnotation) {
        return this.getFirstBasicInWindow(windowAnnotation, this.currentIt);
    }

    public RutaBasic getFirstBasicInWindow(AnnotationFS windowAnnotation, FSIterator<AnnotationFS> it) {
        if (windowAnnotation instanceof RutaBasic) {
            return (RutaBasic)windowAnnotation;
        }
        it.moveTo((FeatureStructure)windowAnnotation);
        if (it.isValid()) {
            return (RutaBasic)it.get();
        }
        return null;
    }

    public List<RutaBasic> getAnnotationsOverlappingWindow(AnnotationFS annotation) {
        if (annotation != null) {
            return this.getBasicsInWindow(annotation);
        }
        return new ArrayList<RutaBasic>();
    }

    public FSIterator<AnnotationFS> getUnfilteredBasicIterator() {
        return this.basicIt;
    }

    public AnnotationFS getDocumentAnnotation() {
        return this.documentAnnotation;
    }

    public RutaAnnotation getCorrectTMA(List<AnnotationFS> annotationsInWindow, RutaAnnotation heuristicAnnotation) {
        for (AnnotationFS annotation : annotationsInWindow) {
            RutaAnnotation tma;
            if (!(annotation instanceof RutaAnnotation) || (tma = (RutaAnnotation)annotation).getBegin() != heuristicAnnotation.getBegin() || tma.getEnd() != heuristicAnnotation.getEnd() || !tma.getAnnotation().getType().equals(heuristicAnnotation.getAnnotation().getType())) continue;
            return tma;
        }
        return null;
    }

    public void retainTypes(List<Type> list) {
        this.filter.retainTypes(list);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void filterTypes(List<Type> list) {
        this.filter.filterTypes(list);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void addFilterTypes(List<Type> types) {
        this.filter.addFilterTypes(types);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void addRetainTypes(List<Type> types) {
        this.filter.addRetainTypes(types);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void removeFilterTypes(List<Type> types) {
        this.filter.removeFilterTypes(types);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public void removeRetainTypes(List<Type> types) {
        this.filter.removeRetainTypes(types);
        this.currentIt = this.filter.createFilteredIterator(this.cas, this.basicType);
    }

    public FilterManager getFilter() {
        return this.filter;
    }

    public RutaBasic getFirstBasicOfAll() {
        if (this.basics.isEmpty()) {
            return null;
        }
        return this.basics.first();
    }

    public Type getDocumentAnnotationType() {
        return this.documentAnnotationType;
    }

    public RutaBasic getNextBasic2(AnnotationFS previous) {
        AnnotationFS pointer = this.cas.createAnnotation(this.basicType, previous.getEnd() - 1, previous.getEnd());
        this.currentIt.moveTo((FeatureStructure)pointer);
        if (this.currentIt.isValid()) {
            RutaBasic basic = (RutaBasic)this.currentIt.get();
            return basic;
        }
        return null;
    }

    public RutaStream getCompleteStream() {
        FilterManager defaultFilter = new FilterManager(this.filter.getDefaultFilterTypes(), this.getCas());
        return new RutaStream(this.getCas(), this.basicIt, this.basicType, defaultFilter, this.lowMemoryProfile, this.simpleGreedyForComposed, this.crowd);
    }

    public int getHistogram(Type type) {
        return this.cas.getAnnotationIndex(type).size();
    }

    public double getIndexPenalty() {
        return this.indexPenalty;
    }

    public RutaBasic getEndAnchor(int end) {
        return this.endAnchors.get(end);
    }

    public RutaBasic getBeginAnchor(int begin) {
        return this.beginAnchors.get(begin);
    }

    public boolean isDynamicAnchoring() {
        return this.dynamicAnchoring;
    }

    public void setDynamicAnchoring(boolean dynamicAnchoring) {
        this.dynamicAnchoring = dynamicAnchoring;
    }

    public void setIndexPenalty(double indexPenalty) {
        this.indexPenalty = indexPenalty;
    }

    public double getAnchoringFactor() {
        return this.anchoringFactor;
    }

    public void setAnchoringFactor(double anchoringFactor) {
        this.anchoringFactor = anchoringFactor;
    }

    public boolean isSimpleGreedyForComposed() {
        return this.simpleGreedyForComposed;
    }

    public void setSimpleGreedyForComposed(boolean simpleGreedyForComposed) {
        this.simpleGreedyForComposed = simpleGreedyForComposed;
    }

    public boolean isVisible(AnnotationFS annotationFS) {
        AnnotationFS windowAnnotation = this.filter.getWindowAnnotation();
        if (windowAnnotation != null && (annotationFS.getBegin() < windowAnnotation.getBegin() || annotationFS.getEnd() > windowAnnotation.getEnd())) {
            return false;
        }
        FSMatchConstraint defaultConstraint = this.filter.getDefaultConstraint();
        return defaultConstraint.match((FeatureStructure)annotationFS);
    }

    public RutaBasic getAnchor(boolean direction, int pointer) {
        if (direction) {
            return this.getBeginAnchor(pointer);
        }
        return this.getEndAnchor(pointer);
    }
}

