/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.tree;

import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.caseditor.view.tree.IAnnotationNode;
import org.apache.uima.ruta.explain.tree.ExplainAbstractTreeNode;
import org.apache.uima.ruta.explain.tree.IEvaluatedNode;
import org.apache.uima.ruta.explain.tree.IExplainTreeNode;

public class RuleElementMatchNode
extends ExplainAbstractTreeNode
implements IEvaluatedNode,
IAnnotationNode {
    private boolean matched;

    public RuleElementMatchNode(IExplainTreeNode parent, FeatureStructure fs, TypeSystem ts) {
        super(parent, fs, ts);
        Feature f = fs.getType().getFeatureByBaseName("baseCondition");
        FeatureStructure baseFS = fs.getFeatureValue(f);
        Feature baseFeat = baseFS.getType().getFeatureByBaseName("value");
        this.matched = baseFS.getBooleanValue(baseFeat);
        f = fs.getType().getFeatureByBaseName("conditions");
        ArrayFS value = (ArrayFS)fs.getFeatureValue(f);
        if (value != null) {
            FeatureStructure[] fsarray;
            for (FeatureStructure each : fsarray = value.toArray()) {
                Feature eachFeat = each.getType().getFeatureByBaseName("value");
                boolean eachValue = each.getBooleanValue(eachFeat);
                this.matched &= eachValue;
            }
        }
    }

    public boolean matched() {
        return this.matched;
    }

    public AnnotationFS getAnnotation() {
        FeatureStructure fs = this.getFeatureStructure();
        if (fs instanceof AnnotationFS) {
            return (AnnotationFS)fs;
        }
        return null;
    }
}

