/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.files;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.ParameterDelegatesSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.apache.uima.taeconfigurator.model.ConfigGroup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PickOverrideKeysAndParmName
extends AbstractDialog {
    private ConfigurationParameter cp;
    private boolean adding;
    private Table paramsUI;
    private Table keysUI;
    private Map delegates;
    public String delegateKeyName;
    public String delegateParameterName;
    private ConfigGroup cg;

    public PickOverrideKeysAndParmName(AbstractSection aSection, Map delegateMap, String message, ConfigurationParameter aCp, ConfigGroup aCg, boolean aAdding) {
        super(aSection, "Delegate Keys and Parameter Name Selection", message);
        this.delegates = delegateMap;
        this.cp = aCp;
        this.cg = aCg;
        this.adding = aAdding;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent);
        Composite twoCol = this.new2ColumnComposite(mainArea);
        this.keysUI = this.newTable(twoCol, 4);
        this.paramsUI = this.newTable(twoCol, 4);
        for (Map.Entry entry : this.delegates.entrySet()) {
            TableItem item = new TableItem(this.keysUI, 0);
            item.setText((String)entry.getKey());
            item.setData(entry);
        }
        this.keysUI.addListener(13, (Listener)this);
        if (0 < this.keysUI.getItemCount()) {
            this.keysUI.setSelection(0);
        }
        return mainArea;
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.keysUI && event.type == 13) {
            this.fillParameterCandidates();
            super.handleEvent(event);
        } else if (event.widget == this.paramsUI && event.type == 13) {
            this.copyValuesFromGUI();
            super.handleEvent(event);
        }
    }

    private void fillParameterCandidates() {
        this.paramsUI.setRedraw(false);
        this.paramsUI.removeAll();
        TableItem selectedItem = this.keysUI.getSelection()[0];
        Map.Entry entry = (Map.Entry)selectedItem.getData();
        String keyName = (String)entry.getKey();
        ResourceSpecifier rs = (ResourceSpecifier)entry.getValue();
        if (rs instanceof AnalysisEngineDescription || rs instanceof CasConsumerDescription || rs instanceof FlowControllerDescription) {
            ConfigurationParameterDeclarations delegateCpd = ((ResourceCreationSpecifier)rs).getMetaData().getConfigurationParameterDeclarations();
            this.addSelectedParms(delegateCpd, keyName);
        }
        if (0 < this.paramsUI.getItemCount()) {
            this.paramsUI.setSelection(0);
        }
        this.paramsUI.setRedraw(true);
    }

    private void addSelectedParms(ConfigurationParameterDeclarations delegateCpd, String keyName) {
        if (this.cg.getKind() == 1) {
            this.addSelectedParms(delegateCpd.getConfigurationParameters(), keyName);
            return;
        }
        this.addSelectedParms(delegateCpd.getCommonParameters(), keyName);
        String[] groupNames = this.cg.getNameArray();
        ConfigurationGroup[] dcgs = delegateCpd.getConfigurationGroupDeclarations(groupNames[0]);
        ArrayList<ConfigurationParameter> cps = new ArrayList<ConfigurationParameter>();
        for (ConfigurationGroup dcg : dcgs) {
            cps.addAll(Arrays.asList(dcg.getConfigurationParameters()));
        }
        for (int i = 1; i < groupNames.length; ++i) {
            ArrayList<ConfigurationParameter> newCps = new ArrayList<ConfigurationParameter>();
            for (ConfigurationParameter cp : cps) {
                ConfigurationParameter sameCp = delegateCpd.getConfigurationParameter(groupNames[i], cp.getName());
                if (sameCp == null) continue;
                newCps.add(cp);
            }
            if (newCps.size() == 0) {
                return;
            }
            cps = newCps;
        }
        this.addSelectedParms(cps.toArray(new ConfigurationParameter[cps.size()]), keyName);
    }

    private void addSelectedParms(ConfigurationParameter[] parms, String keyName) {
        boolean isMultiValued = this.cp.isMultiValued();
        String type = this.cp.getType();
        if (null != parms) {
            for (int i = 0; i < parms.length; ++i) {
                if (isMultiValued != parms[i].isMultiValued() || null != type && !"".equals(type) && !type.equals(parms[i].getType())) continue;
                String override = keyName + "/" + parms[i].getName();
                if (this.adding && null != ParameterDelegatesSection.getOverridingParmName(override, this.cg)) continue;
                TableItem tableItem = new TableItem(this.paramsUI, 0);
                tableItem.setText(parms[i].getName());
                tableItem.setData((Object)parms[i]);
            }
        }
    }

    @Override
    public void copyValuesFromGUI() {
        this.delegateKeyName = this.keysUI.getSelection()[0].getText();
        this.delegateParameterName = this.paramsUI.getSelection()[0].getText();
    }

    @Override
    public void enableOK() {
        this.okButton.setEnabled(0 < this.keysUI.getSelectionCount() && 0 < this.paramsUI.getSelectionCount());
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

