/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.text.MessageFormat;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;

public class PrimitiveSection
extends AbstractSection {
    private Label implNameLabel;
    private Text implName;
    private Button findButton;
    private Button multipleDeploymentAllowed;
    private Button modifiesCas;
    private Button outputsNewCASes;

    @Override
    public void enable() {
    }

    public PrimitiveSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Runtime Information", "This section describes information about how to run this component");
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.enableBorders(sectionClient);
        this.modifiesCas = this.newCheckBox(sectionClient, "updates the CAS", "check this if this component updates the CAS");
        PrimitiveSection.spacer(sectionClient);
        if (this.isAeDescriptor() || this.isCasConsumerDescriptor() || this.isFlowControllerDescriptor()) {
            this.multipleDeploymentAllowed = this.newCheckBox(sectionClient, "multiple deployment allowed", "check this to allow multiple instances of this engine to be deployed that can run in parallel");
            PrimitiveSection.spacer(sectionClient);
        }
        if (this.isAeDescriptor()) {
            this.outputsNewCASes = this.newCheckBox(sectionClient, "Outputs new CASes", "check this for primitive components that output new CASes, or for aggregates which contain a CAS Multiplier, where the new CASes are returned out of the aggregate.");
            PrimitiveSection.spacer(sectionClient);
        }
        this.implNameLabel = this.newLabelWithData(sectionClient, "");
        this.implName = this.newTextWithTip(sectionClient, "", "");
        PrimitiveSection.spacer(sectionClient);
        this.findButton = this.newPushButton(sectionClient, "Browse", "", true, 131072);
        this.findButton.setLayoutData((Object)new GridData(128));
        this.toolkit.paintBordersFor(sectionClient);
    }

    public void refresh() {
        super.refresh();
        String implKind = this.editor.getAeDescription().getFrameworkImplementation();
        if ("org.apache.uima.cpp".equals(implKind)) {
            this.implNameLabel.setText("Name of the .dll file");
            this.implName.setToolTipText("Enter the name of the .dll file here.");
            this.findButton.setToolTipText("Browse the file system for the .dll file.");
        } else {
            this.implNameLabel.setText("Name of the Java class file");
            this.implName.setToolTipText("Enter the name of the Java class that implements this component.");
            this.findButton.setToolTipText("Browse for the Java class that implmenets this component.");
        }
        if (this.isPrimitive()) {
            this.setEnabled(true);
            String modelImplName = this.editor.getAeDescription().getAnnotatorImplementationName();
            this.implName.setText(PrimitiveSection.convertNull(modelImplName));
            this.getSection().layout();
        } else {
            this.implName.setText("");
            this.setEnabled(false);
        }
        OperationalProperties ops = this.getOperationalProperties();
        if (null != ops) {
            PrimitiveSection.setButtonSelection(this.modifiesCas, ops.getModifiesCas());
            PrimitiveSection.setButtonSelection(this.multipleDeploymentAllowed, ops.isMultipleDeploymentAllowed());
            PrimitiveSection.setButtonSelection(this.outputsNewCASes, ops.getOutputsNewCASes());
        } else {
            PrimitiveSection.setButtonSelection(this.modifiesCas, true);
            PrimitiveSection.setButtonSelection(this.multipleDeploymentAllowed, false);
            PrimitiveSection.setButtonSelection(this.outputsNewCASes, false);
        }
    }

    public void handleEvent(Event event) {
        this.valueChanged = false;
        OperationalProperties ops = this.getOperationalProperties();
        if (event.widget == this.findButton) {
            String className = null;
            try {
                String implKind = this.editor.getAeDescription().getFrameworkImplementation();
                if ("org.apache.uima.cpp".equals(implKind)) {
                    FileDialog dialog = new FileDialog(this.getSection().getShell(), 0);
                    String[] extensions = new String[]{"*.dll"};
                    dialog.setFilterExtensions(extensions);
                    String sStartDir = Platform.getLocation().toString();
                    dialog.setFilterPath(sStartDir);
                    className = dialog.open();
                } else {
                    SelectionDialog typeDialog = JavaUI.createTypeDialog((Shell)this.getSection().getShell(), (IRunnableContext)this.editor.getEditorSite().getWorkbenchWindow(), (IJavaSearchScope)this.editor.getSearchScopeForDescriptorType(), (int)2, (boolean)false, (String)"*");
                    typeDialog.setTitle(MessageFormat.format("Choose the {0} implementation class", this.editor.descriptorTypeString()));
                    typeDialog.setMessage("Filter/mask:");
                    if (typeDialog.open() == 1) {
                        return;
                    }
                    Object[] result = typeDialog.getResult();
                    if (result != null && result.length > 0) {
                        className = ((IType)result[0]).getFullyQualifiedName();
                    }
                }
                if (className == null || className.equals("")) {
                    return;
                }
                this.implName.setText(className);
                this.editor.getAeDescription().setAnnotatorImplementationName(className);
                this.valueChanged = true;
            }
            catch (JavaModelException e) {
                throw new InternalErrorCDE("unexpected Exception", e);
            }
        } else if (event.widget == this.modifiesCas) {
            ops.setModifiesCas(this.setValueChangedBoolean(this.modifiesCas.getSelection(), ops.getModifiesCas()));
        } else if (event.widget == this.multipleDeploymentAllowed) {
            ops.setMultipleDeploymentAllowed(this.setValueChangedBoolean(this.multipleDeploymentAllowed.getSelection(), ops.isMultipleDeploymentAllowed()));
        } else if (event.widget == this.outputsNewCASes) {
            ops.setOutputsNewCASes(this.setValueChangedBoolean(this.outputsNewCASes.getSelection(), ops.getOutputsNewCASes()));
        } else if (event.widget == this.implName) {
            this.editor.getAeDescription().setAnnotatorImplementationName(this.setValueChanged(this.implName.getText(), this.editor.getAeDescription().getAnnotatorImplementationName()));
        }
        if (this.valueChanged) {
            this.editor.setFileDirty();
        }
    }

    public void setEnabled(boolean enabled) {
        this.implNameLabel.setEnabled(enabled);
        this.implName.setEnabled(enabled);
        this.findButton.setEnabled(enabled);
        PrimitiveSection.enableCtrl((Control)this.modifiesCas, true);
        PrimitiveSection.enableCtrl((Control)this.multipleDeploymentAllowed, true);
        PrimitiveSection.enableCtrl((Control)this.outputsNewCASes, true);
    }
}

