/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.io.IOException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.ImportSection;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.swt.widgets.Composite;

public class TypePriorityImportSection
extends ImportSection {
    public TypePriorityImportSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Type Priority Imports", "The following type priority imports are included as part of the type priorities:");
    }

    @Override
    protected boolean isAppropriate() {
        return true;
    }

    @Override
    protected String getDescriptionFromImport(String source) throws InvalidXMLException, IOException {
        TypePriorities parsedImportItem = UIMAFramework.getXMLParser().parseTypePriorities(new XMLInputSource(source));
        return parsedImportItem.getDescription();
    }

    @Override
    protected Import[] getModelImportArray() {
        return this.getTypePriorities().getImports();
    }

    @Override
    protected void setModelImportArray(Import[] imports) {
        this.getTypePriorities().setImports(imports);
    }

    @Override
    protected void clearModelBaseValue() {
        this.getTypePriorities().setPriorityLists(typePriorityList0);
    }

    @Override
    protected boolean isValidImport(String title, String message) {
        CAS savedCAS = this.editor.getCurrentView();
        TypePriorities savedTP = this.editor.getMergedTypePriorities();
        if (null != savedTP) {
            savedTP = (TypePriorities)savedTP.clone();
        }
        try {
            this.editor.setMergedTypePriorities();
            this.editor.descriptorCAS.validate();
        }
        catch (ResourceInitializationException e1) {
            this.revertMsg(title, message, this.editor.getMessagesToRootCause(e1));
            this.editor.setMergedTypePriorities(savedTP);
            this.editor.descriptorCAS.set(savedCAS);
            return false;
        }
        return true;
    }

    @Override
    protected void finishImportChangeAction() {
    }
}

