/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.outline;

import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.outline.AnnotationTreeNodeList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;

public class AnnotationTreeNode
implements IAdaptable {
    private AnnotationTreeNode mParent;
    private final AnnotationTreeNodeList mChildren;
    private final AnnotationFS mAnnotation;

    AnnotationTreeNode(ICasDocument document, AnnotationFS annotation) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)annotation);
        this.mAnnotation = annotation;
        this.mChildren = new AnnotationTreeNodeList(document);
    }

    AnnotationTreeNode getParent() {
        return this.mParent;
    }

    List<AnnotationTreeNode> getChildren() {
        return this.mChildren.getElements();
    }

    AnnotationFS getAnnotation() {
        return this.mAnnotation;
    }

    boolean isChild(AnnotationTreeNode node) {
        return this.getAnnotation().getBegin() <= node.getAnnotation().getBegin() && this.getAnnotation().getEnd() >= node.getAnnotation().getEnd();
    }

    void addChild(AnnotationTreeNode node) {
        node.mParent = this;
        this.mChildren.add(node);
        this.mChildren.buildTree();
    }

    public Object getAdapter(Class adapter) {
        if (AnnotationFS.class.equals((Object)adapter) || FeatureStructure.class.equals((Object)adapter)) {
            return this.getAnnotation();
        }
        return null;
    }

    public int hashCode() {
        return this.mAnnotation._id();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnnotationTreeNode) {
            AnnotationTreeNode other = (AnnotationTreeNode)obj;
            return other.getAnnotation().equals(this.mAnnotation);
        }
        return false;
    }
}

