/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.util.Primitives;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;

public final class FeatureValue
implements IAdaptable {
    private FeatureStructure mStructure;
    private Feature mFeature;

    public FeatureValue(ICasDocument document, FeatureStructure structure, Feature feature) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)feature);
        this.mFeature = feature;
        Assert.isNotNull((Object)feature);
        this.mStructure = structure;
    }

    public FeatureStructure getFeatureStructure() {
        return this.mStructure;
    }

    public Object getValue() {
        if (this.mFeature.getRange().isPrimitive()) {
            return Primitives.getPrimitive(this.mStructure, this.mFeature);
        }
        return this.mStructure.getFeatureValue(this.mFeature);
    }

    public Object getAdapter(Class adapter) {
        if (AnnotationFS.class.equals((Object)adapter) && this.getValue() instanceof AnnotationFS) {
            return this.getValue();
        }
        if (FeatureStructure.class.equals((Object)adapter) && this.getValue() instanceof FeatureStructure) {
            return this.getValue();
        }
        return null;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (this == object) {
            result = true;
        } else if (object != null && object instanceof FeatureValue) {
            FeatureValue valueToCompare = (FeatureValue)object;
            result = valueToCompare.mStructure.equals((Object)this.mStructure) && valueToCompare.mFeature.equals(this.mFeature);
        }
        return result;
    }

    public int hashCode() {
        return this.mStructure.hashCode() | this.mFeature.hashCode();
    }

    public Feature getFeature() {
        return this.mFeature;
    }
}

