/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.ui;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerController;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerFactory;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerParameter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Control;

public class LearnerConfigurator {
    Map<String, Control> paramControls = new HashMap<String, Control>();
    private TextRulerLearnerController algorithmController;

    public LearnerConfigurator(TextRulerLearnerController algController) {
        this.algorithmController = algController;
    }

    public TextRulerLearnerController getController() {
        return this.algorithmController;
    }

    public String getID() {
        return this.algorithmController.getID();
    }

    public Map<String, Object> getCurrentParameterSettings() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IPreferenceStore store = TextRulerPlugin.getDefault().getPreferenceStore();
        TextRulerLearnerFactory f = this.algorithmController.getFactory();
        TextRulerLearnerParameter[] params = f.getAlgorithmParameters();
        if (params != null) {
            block7: for (int i = 0; i < params.length; ++i) {
                TextRulerLearnerParameter p = params[i];
                String id = this.algorithmController.getID() + "." + p.id;
                switch (p.type) {
                    case ML_BOOL_PARAM: {
                        result.put(p.id, store.getBoolean(id));
                        continue block7;
                    }
                    case ML_FLOAT_PARAM: {
                        result.put(p.id, Float.valueOf(store.getFloat(id)));
                        continue block7;
                    }
                    case ML_DOUBLE_PARAM: {
                        result.put(p.id, store.getDouble(id));
                        continue block7;
                    }
                    case ML_INT_PARAM: {
                        result.put(p.id, store.getInt(id));
                        continue block7;
                    }
                    case ML_STRING_PARAM: {
                        result.put(p.id, store.getString(id));
                        continue block7;
                    }
                }
            }
        }
        return result;
    }
}

