/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.template;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.pull.ApplicationTool;

public class HtmlPageAttributes
implements ApplicationTool {
    private String title;
    private final Map<String, String> bodyAttributes = new LinkedHashMap<String, String>();
    private final List<String> scripts = new ArrayList<String>();
    private final List<LinkTag> linkTags = new ArrayList<LinkTag>();
    private final List<String> styles = new ArrayList<String>();
    private final Map<String, String> metaTags = new LinkedHashMap<String, String>();
    private final Map<String, String> httpEquivs = new LinkedHashMap<String, String>();
    private String doctype = null;

    public HtmlPageAttributes() {
        this.init(null);
    }

    @Override
    public void init(Object data) {
        this.title = null;
        this.bodyAttributes.clear();
        this.scripts.clear();
        this.linkTags.clear();
        this.styles.clear();
        this.metaTags.clear();
        this.httpEquivs.clear();
    }

    @Override
    public void refresh() {
    }

    public HtmlPageAttributes setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitle() {
        if (StringUtils.isEmpty((String)this.title)) {
            return "";
        }
        return this.title;
    }

    public HtmlPageAttributes addBodyAttribute(String name, String value) {
        this.bodyAttributes.put(name, value);
        return this;
    }

    public Map<String, String> getBodyAttributes() {
        return this.bodyAttributes;
    }

    public HtmlPageAttributes addScript(String scriptURL) {
        this.scripts.add(scriptURL);
        return this;
    }

    public List<String> getScripts() {
        return this.scripts;
    }

    public HtmlPageAttributes addStyleSheet(String styleSheetURL) {
        this.addStyleSheet(styleSheetURL, "screen", null, "text/css");
        return this;
    }

    public HtmlPageAttributes addStyleSheet(String styleSheetURL, String media, String title, String type) {
        LinkTag ss = new LinkTag("stylesheet", styleSheetURL);
        ss.setMedia(media);
        ss.setTitle(title);
        ss.setType(type);
        this.linkTags.add(ss);
        return this;
    }

    public HtmlPageAttributes addLink(String relation, String linkURL) {
        return this.addLink(relation, linkURL, null, null);
    }

    public HtmlPageAttributes addLink(String relation, String linkURL, String title) {
        return this.addLink(relation, linkURL, title, null);
    }

    public HtmlPageAttributes addLink(String relation, String linkURL, String title, String type) {
        LinkTag ss = new LinkTag(relation, linkURL);
        ss.setTitle(title);
        ss.setType(type);
        this.linkTags.add(ss);
        return this;
    }

    public List<LinkTag> getLinks() {
        return this.linkTags;
    }

    public HtmlPageAttributes addStyle(String styleText) {
        this.styles.add(styleText);
        return this;
    }

    public List<String> getStyles() {
        return this.styles;
    }

    public HtmlPageAttributes setKeywords(String keywords) {
        this.metaTags.put("keywords", keywords);
        return this;
    }

    public HtmlPageAttributes setHttpEquiv(String httpEquiv, String content) {
        this.httpEquivs.put(httpEquiv, content);
        return this;
    }

    public HtmlPageAttributes setDescription(String description) {
        this.metaTags.put("description", description);
        return this;
    }

    public HtmlPageAttributes setBackground(String url) {
        this.bodyAttributes.put("background", url);
        return this;
    }

    public HtmlPageAttributes setBgColor(String color) {
        this.bodyAttributes.put("BGCOLOR", color);
        return this;
    }

    public HtmlPageAttributes setTextColor(String color) {
        this.bodyAttributes.put("TEXT", color);
        return this;
    }

    public HtmlPageAttributes setLinkColor(String color) {
        this.bodyAttributes.put("LINK", color);
        return this;
    }

    public HtmlPageAttributes setVlinkColor(String color) {
        this.bodyAttributes.put("VLINK", color);
        return this;
    }

    public HtmlPageAttributes setAlinkColor(String color) {
        this.bodyAttributes.put("ALINK", color);
        return this;
    }

    public Map<String, String> getHttpEquivs() {
        return this.httpEquivs;
    }

    public Map<String, String> getMetaTags() {
        return this.metaTags;
    }

    public String toString() {
        return "";
    }

    public String getDefaultDoctype() {
        if (this.doctype == null) {
            Configuration conf = Turbine.getConfiguration();
            String tag = conf.getString("default.html.doctype.root.element", "HTML");
            if (StringUtils.isEmpty((String)tag)) {
                this.doctype = "";
            } else {
                String identifier = conf.getString("default.html.doctype.identifier", "-//W3C//DTD HTML 4.01 Transitional//EN");
                String uri = conf.getString("default.html.doctype.url", "http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd");
                this.doctype = this.buildDoctype(tag, identifier, uri);
            }
        }
        return this.doctype;
    }

    private String buildDoctype(String tag, String identifier, String uri) {
        StringBuilder doctypeBuf = new StringBuilder("<!DOCTYPE ");
        doctypeBuf.append(tag);
        if (StringUtils.isNotEmpty((String)identifier)) {
            doctypeBuf.append(" PUBLIC \"");
            doctypeBuf.append(identifier);
            doctypeBuf.append("\" \"");
        } else {
            doctypeBuf.append(" SYSTEM \"");
        }
        doctypeBuf.append(uri);
        doctypeBuf.append("\">");
        return doctypeBuf.toString();
    }

    public static class LinkTag {
        private String relation;
        private String url;
        private String title;
        private String media;
        private String type;

        public LinkTag(String relation, String url) {
            this.setRelation(relation);
            this.setUrl(url);
        }

        public String getType() {
            return StringUtils.isEmpty((String)this.type) ? "" : this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUrl() {
            return this.url;
        }

        private void setUrl(String url) {
            this.url = url;
        }

        public String getTitle() {
            return StringUtils.isEmpty((String)this.title) ? "" : this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getMedia() {
            return StringUtils.isEmpty((String)this.media) ? "" : this.media;
        }

        public void setMedia(String media) {
            this.media = media;
        }

        public String getRelation() {
            return StringUtils.isEmpty((String)this.relation) ? "" : this.relation;
        }

        public void setRelation(String relation) {
            this.relation = relation;
        }
    }
}

