/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import org.apache.ecs.filter.CharacterFilter;

public abstract class InputFilterUtils {
    private static final CharacterFilter filter = InputFilterUtils.htmlFilter();
    private static final CharacterFilter minFilter = InputFilterUtils.htmlMinFilter();

    public static String prepareText(String s) {
        return filter.process(s);
    }

    public static String prepareTextMinimum(String s) {
        return minFilter.process(s);
    }

    private static CharacterFilter htmlFilter() {
        CharacterFilter filter = new CharacterFilter();
        filter.addAttribute("\"", (Object)"&#34;");
        filter.addAttribute("'", (Object)"&#8217;");
        filter.addAttribute("&", (Object)"&#38;");
        filter.addAttribute("<", (Object)"&#60;");
        filter.addAttribute(">", (Object)"&#62;");
        return filter;
    }

    private static CharacterFilter htmlMinFilter() {
        CharacterFilter filter = new CharacterFilter();
        filter.removeAttribute(">");
        filter.removeAttribute("\"");
        filter.removeAttribute("'");
        filter.removeAttribute("&");
        filter.addAttribute("<", (Object)"&#60;");
        return filter;
    }
}

