/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.model.turbine.TurbineUserManager;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.turbine.om.security.DefaultUserImpl;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.security.UserManager;
import org.apache.turbine.util.ObjectUtils;

public class DefaultUserManager
implements UserManager {
    private TurbineUserManager umDelegate = null;

    protected <U extends User> U wrap(TurbineUser user) {
        DefaultUserImpl u = new DefaultUserImpl(user);
        return (U)u;
    }

    @Override
    public void init(Configuration conf) {
        ServiceManager manager = TurbineServices.getInstance();
        this.umDelegate = (TurbineUserManager)manager.getService(TurbineUserManager.ROLE);
    }

    @Override
    public boolean accountExists(User user) throws DataBackendException {
        return this.umDelegate.checkExists((org.apache.fulcrum.security.entity.User)user);
    }

    @Override
    public boolean accountExists(String userName) throws DataBackendException {
        return this.umDelegate.checkExists(userName);
    }

    @Override
    public <U extends User> U retrieve(String username) throws UnknownEntityException, DataBackendException {
        TurbineUser u = (TurbineUser)this.umDelegate.getUser(username);
        return this.wrap(u);
    }

    @Override
    public List<? extends User> retrieveList(Object criteria) throws DataBackendException {
        UserSet uset = this.umDelegate.getAllUsers();
        ArrayList userList = new ArrayList();
        for (org.apache.fulcrum.security.entity.User u : uset) {
            TurbineUser tu = (TurbineUser)u;
            userList.add(this.wrap(tu));
        }
        return userList;
    }

    @Override
    public <U extends User> U retrieve(String username, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        TurbineUser u = (TurbineUser)this.umDelegate.getUser(username, password);
        return this.wrap(u);
    }

    @Override
    public void store(User user) throws UnknownEntityException, DataBackendException {
        try {
            user.setObjectdata(ObjectUtils.serializeMap(user.getPermStorage()));
        }
        catch (Exception e) {
            throw new DataBackendException("Could not serialize permanent storage", (Throwable)e);
        }
        this.umDelegate.saveUser((org.apache.fulcrum.security.entity.User)((DefaultUserImpl)user).getUserDelegate());
    }

    @Override
    public void saveOnSessionUnbind(User user) throws UnknownEntityException, DataBackendException {
        this.store(user);
    }

    @Override
    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        this.umDelegate.authenticate((org.apache.fulcrum.security.entity.User)user, password);
    }

    @Override
    public void createAccount(User user, String initialPassword) throws EntityExistsException, DataBackendException {
        this.umDelegate.addUser((org.apache.fulcrum.security.entity.User)user, initialPassword);
    }

    @Override
    public void removeAccount(User user) throws UnknownEntityException, DataBackendException {
        this.umDelegate.removeUser((org.apache.fulcrum.security.entity.User)user);
    }

    @Override
    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        this.umDelegate.changePassword((org.apache.fulcrum.security.entity.User)((DefaultUserImpl)user).getUserDelegate(), oldPassword, newPassword);
    }

    @Override
    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        this.umDelegate.forcePassword((org.apache.fulcrum.security.entity.User)user, password);
    }

    @Override
    public <T extends User> T getAnonymousUser() throws UnknownEntityException {
        TurbineUser u = (TurbineUser)this.umDelegate.getAnonymousUser();
        return (T)this.wrap(u);
    }

    @Override
    public boolean isAnonymousUser(User u) {
        return this.umDelegate.isAnonymousUser((org.apache.fulcrum.security.entity.User)u);
    }

    @Override
    public <T extends User> T getUserInstance() throws DataBackendException {
        TurbineUser u = (TurbineUser)this.umDelegate.getUserInstance();
        return (T)this.wrap(u);
    }

    @Override
    public <T extends User> T getUserInstance(String userName) throws DataBackendException {
        TurbineUser u = (TurbineUser)this.umDelegate.getUserInstance(userName);
        return (T)this.wrap(u);
    }

    @Override
    public <T extends AccessControlList> T getACL(User user) throws UnknownEntityException {
        return (T)this.umDelegate.getACL((org.apache.fulcrum.security.entity.User)user);
    }
}

