/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.pool.PoolService;
import org.apache.fulcrum.security.model.turbine.TurbineUserManager;
import org.apache.turbine.Turbine;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.pull.PipelineDataApplicationTool;
import org.apache.turbine.services.pull.PullService;
import org.apache.turbine.services.pull.RunDataApplicationTool;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TurbinePullService
extends TurbineBaseService
implements PullService {
    private static Log log = LogFactory.getLog(TurbinePullService.class);
    private PoolService pool = null;
    private VelocityService velocity = null;
    private Context globalContext;
    private List<ToolData> globalTools;
    private List<ToolData> requestTools;
    private List<ToolData> sessionTools;
    private List<ToolData> authorizedTools;
    private List<ToolData> persistentTools;
    private String resourcesDirectory;
    private boolean refreshToolsPerRequest = false;

    @Override
    public void init() throws InitializationException {
        try {
            this.pool = (PoolService)TurbineServices.getInstance().getService(PoolService.ROLE);
            if (this.pool == null) {
                throw new InitializationException("Pull Service requires configured Pool Service!");
            }
            this.initPullService();
            this.setInit(true);
            this.velocity = TurbineVelocity.getService();
            if (this.velocity != null) {
                this.initPullTools();
            } else {
                log.info((Object)"Velocity Service not configured, skipping pull tools!");
            }
        }
        catch (Exception e) {
            throw new InitializationException("TurbinePullService failed to initialize", e);
        }
    }

    private void initPullService() throws Exception {
        Configuration conf = this.getConfiguration();
        this.resourcesDirectory = conf.getString("tools.resources.dir", "resources");
        this.refreshToolsPerRequest = conf.getBoolean("tools.per.request.refresh", false);
        if (this.refreshToolsPerRequest) {
            log.info((Object)"Pull Model tools will be refreshed on a per request basis.");
        }
    }

    private void initPullTools() throws Exception {
        Configuration conf = Turbine.getConfiguration();
        log.debug((Object)"Global Tools:");
        this.globalTools = this.getTools(conf.subset("tool.global"));
        log.debug((Object)"Request Tools:");
        this.requestTools = this.getTools(conf.subset("tool.request"));
        log.debug((Object)"Session Tools:");
        this.sessionTools = this.getTools(conf.subset("tool.session"));
        log.debug((Object)"Authorized Tools:");
        this.authorizedTools = this.getTools(conf.subset("tool.authorized"));
        log.debug((Object)"Persistent Tools:");
        this.persistentTools = this.getTools(conf.subset("tool.persistent"));
        this.globalContext = this.velocity.getNewContext();
        this.populateWithGlobalTools(this.globalContext);
    }

    private List<ToolData> getTools(Configuration toolConfig) {
        ArrayList<ToolData> tools = new ArrayList<ToolData>();
        if (toolConfig == null) {
            return tools;
        }
        Iterator it = toolConfig.getKeys();
        while (it.hasNext()) {
            String toolName = (String)it.next();
            String toolClassName = toolConfig.getString(toolName);
            try {
                Class<ApplicationTool> toolClass = Class.forName(toolClassName);
                tools.add(new ToolData(toolName, toolClassName, toolClass));
                log.info((Object)("Tool " + toolClassName + " to add to the context as '$" + toolName + "'"));
            }
            catch (Exception e) {
                log.error((Object)("Cannot instantiate tool class " + toolClassName + ": "), (Throwable)e);
            }
        }
        return tools;
    }

    @Override
    public Context getGlobalContext() {
        if (this.refreshToolsPerRequest) {
            this.refreshGlobalTools();
        }
        return this.globalContext;
    }

    @Override
    public void populateContext(Context context, RunData data) {
        this.populateWithRequestTools(context, data);
        Object user = data.getUser();
        this.populateWithSessionTools(this.sessionTools, context, data, (User)user);
        TurbineUserManager userManager = (TurbineUserManager)TurbineServices.getInstance().getService(TurbineUserManager.ROLE);
        if (!userManager.isAnonymousUser(user) && user.hasLoggedIn()) {
            this.populateWithSessionTools(this.authorizedTools, context, data, (User)user);
            this.populateWithPermTools(this.persistentTools, context, data, (User)user);
        }
    }

    @Override
    public void populateContext(Context context, PipelineData pipelineData) {
        RunData data = (RunData)pipelineData;
        this.populateWithRequestTools(context, pipelineData);
        Object user = data.getUser();
        this.populateWithSessionTools(this.sessionTools, context, pipelineData, (User)user);
        TurbineUserManager userManager = (TurbineUserManager)TurbineServices.getInstance().getService(TurbineUserManager.ROLE);
        if (!userManager.isAnonymousUser(user) && user.hasLoggedIn()) {
            this.populateWithSessionTools(this.authorizedTools, context, pipelineData, (User)user);
            this.populateWithPermTools(this.persistentTools, context, pipelineData, (User)user);
        }
    }

    private void populateWithGlobalTools(Context context) {
        for (ToolData toolData : this.globalTools) {
            try {
                ApplicationTool tool = toolData.toolClass.newInstance();
                this.initTool(tool, null);
                context.put(toolData.toolName, (Object)tool);
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate global tool " + toolData.toolName + " from a " + toolData.toolClassName + " object"), (Throwable)e);
            }
        }
    }

    private void populateWithRequestTools(Context context, RunData data) {
        for (ToolData toolData : this.requestTools) {
            try {
                Object tool = this.pool.getInstance(toolData.toolClass);
                this.initTool(tool, data);
                context.put(toolData.toolName, tool);
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate request tool " + toolData.toolName + " from a " + toolData.toolClassName + " object"), (Throwable)e);
            }
        }
    }

    private void populateWithRequestTools(Context context, PipelineData pipelineData) {
        for (ToolData toolData : this.requestTools) {
            try {
                Object tool = this.pool.getInstance(toolData.toolClass);
                this.initTool(tool, pipelineData);
                context.put(toolData.toolName, tool);
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate request tool " + toolData.toolName + " from a " + toolData.toolClassName + " object"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateWithSessionTools(List<ToolData> tools, Context context, PipelineData pipelineData, User user) {
        RunData runData = (RunData)pipelineData;
        for (ToolData toolData : tools) {
            try {
                HttpSession httpSession = runData.getSession();
                synchronized (httpSession) {
                    Object tool = runData.getSession().getAttribute("turbine.sessiontools." + toolData.toolClassName);
                    if (tool == null) {
                        tool = this.pool.getInstance(toolData.toolClass);
                        this.initTool(tool, user);
                    }
                    if (tool != null) {
                        runData.getSession().setAttribute("turbine.sessiontools." + tool.getClass().getName(), tool);
                        if (this.refreshToolsPerRequest) {
                            this.refreshTool(tool, pipelineData);
                        }
                        log.debug((Object)("Adding " + tool + " to ctx as " + toolData.toolName));
                        context.put(toolData.toolName, tool);
                    } else {
                        log.info((Object)("Tool " + toolData.toolName + " was null, skipping it."));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate session tool " + toolData.toolName + " from a " + toolData.toolClassName + " object"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateWithSessionTools(List<ToolData> tools, Context context, RunData data, User user) {
        for (ToolData toolData : tools) {
            try {
                HttpSession httpSession = data.getSession();
                synchronized (httpSession) {
                    Object tool = data.getSession().getAttribute("turbine.sessiontools." + toolData.toolClassName);
                    if (tool == null) {
                        tool = this.pool.getInstance(toolData.toolClass);
                        this.initTool(tool, user);
                    }
                    if (tool != null) {
                        data.getSession().setAttribute("turbine.sessiontools." + tool.getClass().getName(), tool);
                        if (this.refreshToolsPerRequest) {
                            this.refreshTool(tool, data);
                        }
                        log.debug((Object)("Adding " + tool + " to ctx as " + toolData.toolName));
                        context.put(toolData.toolName, tool);
                    } else {
                        log.info((Object)("Tool " + toolData.toolName + " was null, skipping it."));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate session tool " + toolData.toolName + " from a " + toolData.toolClassName + " object"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateWithPermTools(List<ToolData> tools, Context context, PipelineData pipelineData, User user) {
        for (ToolData toolData : tools) {
            try {
                User user2 = user;
                synchronized (user2) {
                    Object tool = user.getPerm(toolData.toolClassName);
                    if (tool == null) {
                        tool = this.pool.getInstance(toolData.toolClass);
                        this.initTool(tool, user);
                        user.setPerm(toolData.toolClassName, tool);
                    }
                    if (tool != null) {
                        if (this.refreshToolsPerRequest) {
                            this.refreshTool(tool, pipelineData);
                        }
                        log.debug((Object)("Adding " + tool + " to ctx as " + toolData.toolName));
                        log.warn((Object)"Persistent scope tools are deprecated.");
                        context.put(toolData.toolName, tool);
                    } else {
                        log.info((Object)("Tool " + toolData.toolName + " was null, skipping it."));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate perm tool " + toolData.toolName + " from a " + toolData.toolClassName + " object"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateWithPermTools(List<ToolData> tools, Context context, RunData data, User user) {
        for (ToolData toolData : tools) {
            try {
                User user2 = user;
                synchronized (user2) {
                    Object tool = user.getPerm(toolData.toolClassName);
                    if (tool == null) {
                        tool = this.pool.getInstance(toolData.toolClass);
                        this.initTool(tool, user);
                        user.setPerm(toolData.toolClassName, tool);
                    }
                    if (tool != null) {
                        if (this.refreshToolsPerRequest) {
                            this.refreshTool(tool, data);
                        }
                        log.debug((Object)("Adding " + tool + " to ctx as " + toolData.toolName));
                        log.warn((Object)"Persistent scope tools are deprecated.");
                        context.put(toolData.toolName, tool);
                    } else {
                        log.info((Object)("Tool " + toolData.toolName + " was null, skipping it."));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate perm tool " + toolData.toolName + " from a " + toolData.toolClassName + " object"), (Throwable)e);
            }
        }
    }

    @Override
    public String getAbsolutePathToResourcesDirectory() {
        return Turbine.getRealPath(this.resourcesDirectory);
    }

    @Override
    public String getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    private void refreshGlobalTools() {
        for (ToolData toolData : this.globalTools) {
            Object tool = this.globalContext.get(toolData.toolName);
            this.refreshTool(tool, null);
        }
    }

    @Override
    public void releaseTools(Context context) {
        this.releaseTools(context, this.requestTools);
    }

    private void releaseTools(Context context, List<ToolData> tools) {
        for (ToolData toolData : tools) {
            Object tool = context.remove((Object)toolData.toolName);
            if (tool == null) continue;
            this.pool.putInstance(tool);
        }
    }

    private void initTool(Object tool, Object param) throws Exception {
        if (param instanceof PipelineData) {
            if (tool instanceof PipelineDataApplicationTool) {
                ((PipelineDataApplicationTool)tool).init(param);
            } else if (tool instanceof RunDataApplicationTool) {
                RunData data = this.getRunData((PipelineData)param);
                ((RunDataApplicationTool)tool).init(data);
            } else if (tool instanceof ApplicationTool) {
                RunData data = this.getRunData((PipelineData)param);
                ((ApplicationTool)tool).init(data);
            }
        } else if (tool instanceof PipelineDataApplicationTool) {
            ((PipelineDataApplicationTool)tool).init(param);
        } else if (tool instanceof RunDataApplicationTool) {
            ((RunDataApplicationTool)tool).init(param);
        } else if (tool instanceof ApplicationTool) {
            ((ApplicationTool)tool).init(param);
        }
    }

    private void refreshTool(Object tool, Object dataObject) {
        RunData data = null;
        PipelineData pipelineData = null;
        if (dataObject instanceof PipelineData) {
            pipelineData = (PipelineData)dataObject;
            data = this.getRunData(pipelineData);
            if (tool instanceof PipelineDataApplicationTool) {
                ((PipelineDataApplicationTool)tool).refresh(pipelineData);
            }
        }
        if (tool instanceof ApplicationTool) {
            ((ApplicationTool)tool).refresh();
        } else if (tool instanceof RunDataApplicationTool) {
            ((RunDataApplicationTool)tool).refresh(data);
        }
    }

    private RunData getRunData(PipelineData pipelineData) {
        if (!(pipelineData instanceof RunData)) {
            throw new RuntimeException("Can't cast to rundata from pipeline data.");
        }
        return (RunData)pipelineData;
    }

    private static class ToolData {
        String toolName;
        String toolClassName;
        Class<ApplicationTool> toolClass;

        public ToolData(String toolName, String toolClassName, Class<ApplicationTool> toolClass) {
            this.toolName = toolName;
            this.toolClassName = toolClassName;
            this.toolClass = toolClass;
        }
    }
}

