/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.Turbine;
import org.apache.turbine.pipeline.AbstractValve;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DefaultSessionTimeoutValve
extends AbstractValve {
    protected int timeout;

    public DefaultSessionTimeoutValve() {
        Configuration cfg = Turbine.getConfiguration();
        this.timeout = cfg.getInt("session.timeout", -1);
    }

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        RunData runData = this.getRunData(pipelineData);
        if (runData.getSession().isNew() && this.timeout != -1) {
            runData.getSession().setMaxInactiveInterval(this.timeout);
        }
        context.invokeNext(pipelineData);
    }
}

