/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineLoader;
import org.apache.turbine.modules.Action;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.pipeline.AbstractValve;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.template.TemplateInfo;

public class DefaultLoginValve
extends AbstractValve {
    @TurbineLoader(value=Action.class)
    private ActionLoader actionLoader;
    @TurbineConfiguration
    private Configuration config;

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        try {
            this.process(pipelineData);
        }
        catch (Exception e) {
            throw new TurbineException(e);
        }
        context.invokeNext(pipelineData);
    }

    protected void process(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        String actionName = data.getAction();
        if (data.hasAction() && actionName.equalsIgnoreCase(this.config.getString("action.login")) || actionName.equalsIgnoreCase(this.config.getString("action.logout"))) {
            Enumeration names;
            if (actionName.equalsIgnoreCase(this.config.getString("action.login")) && (names = data.getSession().getAttributeNames()) != null) {
                ArrayList nameList = new ArrayList();
                while (names.hasMoreElements()) {
                    nameList.add(names.nextElement());
                }
                HttpSession session = data.getSession();
                for (String name : nameList) {
                    try {
                        session.removeAttribute(name);
                    }
                    catch (IllegalStateException invalidatedSession) {
                        break;
                    }
                }
            }
            this.actionLoader.exec(pipelineData, data.getAction());
            this.cleanupTemplateContext(data);
            data.setAction(null);
        }
    }

    private void cleanupTemplateContext(RunData data) throws Exception {
        TemplateInfo ti = data.getTemplateInfo();
        if (ti != null) {
            ti.removeTemp("VELOCITY_CONTEXT");
        }
    }
}

