/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.layouts;

import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.annotation.TurbineLoader;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.template.TemplateNavigation;
import org.apache.velocity.context.Context;

public class VelocityOnlyLayout
extends Layout {
    private static Log log = LogFactory.getLog(VelocityOnlyLayout.class);
    private final String prefix = "layouts/";
    @TurbineService
    private VelocityService velocityService;
    @TurbineLoader(value=Screen.class)
    private ScreenLoader screenLoader;

    @Override
    public void doBuild(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        Context context = this.velocityService.getContext(pipelineData);
        String screenName = data.getScreen();
        log.debug((Object)("Loading Screen " + screenName));
        String results = this.screenLoader.eval(pipelineData, screenName);
        String returnValue = StringUtils.defaultIfEmpty((String)results, (String)"");
        context.put("screen_placeholder", (Object)returnValue);
        context.put("navigation", (Object)new TemplateNavigation(data));
        String templateName = data.getTemplateInfo().getLayoutTemplate();
        data.getResponse().setLocale(data.getLocale());
        data.getResponse().setContentType(data.getContentType());
        log.debug((Object)("Now trying to render layout " + templateName));
        this.velocityService.handleRequest(context, "layouts/" + templateName, (OutputStream)data.getResponse().getOutputStream());
    }
}

