/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractOutputTarget;

public class WriterTarget
extends AbstractOutputTarget {
    private Writer m_output;

    public WriterTarget(Writer writer, Formatter formatter) {
        super(formatter);
        if (null != writer) {
            this.setWriter(writer);
            this.open();
        }
    }

    protected synchronized void setWriter(Writer writer) {
        if (null == writer) {
            throw new NullPointerException("writer property must not be null");
        }
        this.m_output = writer;
    }

    protected void write(String data) {
        try {
            this.m_output.write(data);
            this.m_output.flush();
        }
        catch (IOException ioe) {
            this.getErrorHandler().error("Caught an IOException", ioe, null);
        }
    }

    public synchronized void close() {
        super.close();
        this.shutdownWriter();
    }

    protected synchronized void shutdownWriter() {
        Writer writer = this.m_output;
        this.m_output = null;
        try {
            if (null != writer) {
                writer.close();
            }
        }
        catch (IOException ioe) {
            this.getErrorHandler().error("Error closing Writer", ioe, null);
        }
    }
}

