/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.impl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptor;
import org.apache.excalibur.instrument.manager.impl.DefaultInstrumentManagerImpl;
import org.apache.excalibur.instrument.manager.impl.InstrumentProxy;
import org.apache.excalibur.instrument.manager.impl.InstrumentableDescriptorImpl;

class InstrumentableProxy
extends AbstractLogEnabled
implements Configurable {
    private DefaultInstrumentManagerImpl m_instrumentManager;
    private InstrumentableProxy m_parentInstrumentableProxy;
    private boolean m_configured;
    private boolean m_registered;
    private String m_name;
    private String m_description;
    private InstrumentableDescriptorImpl m_descriptor;
    private HashMap m_childInstrumentableProxies = new HashMap();
    private InstrumentableProxy[] m_childInstrumentableProxyArray;
    private InstrumentableDescriptor[] m_childInstrumentableDescriptorArray;
    private HashMap m_instrumentProxies = new HashMap();
    private InstrumentProxy[] m_instrumentProxyArray;
    private InstrumentDescriptor[] m_instrumentDescriptorArray;
    private int m_stateVersion;

    InstrumentableProxy(DefaultInstrumentManagerImpl instrumentManager, InstrumentableProxy parentInstrumentableProxy, String name, String description) {
        this.m_instrumentManager = instrumentManager;
        this.m_parentInstrumentableProxy = parentInstrumentableProxy;
        this.m_name = name;
        this.m_description = description;
        this.m_descriptor = new InstrumentableDescriptorImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_description = configuration.getAttribute("description", this.m_description);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Configuring Instrumentable: " + this.m_name + " as \"" + this.m_description + "\"");
            }
            this.m_configured = true;
            Configuration[] childConfs = configuration.getChildren("instrumentable");
            for (int i = 0; i < childConfs.length; ++i) {
                Configuration childConf = childConfs[i];
                String childName = childConf.getAttribute("name");
                String fullChildName = this.m_name + "." + childName;
                InstrumentableProxy childProxy = this.getChildInstrumentableProxy(fullChildName);
                if (childProxy == null) {
                    childProxy = new InstrumentableProxy(this.m_instrumentManager, this, fullChildName, childName);
                    childProxy.enableLogging(this.getLogger());
                    this.m_instrumentManager.incrementInstrumentableCount();
                    this.m_childInstrumentableProxies.put(fullChildName, childProxy);
                    this.m_childInstrumentableProxyArray = null;
                    this.m_childInstrumentableDescriptorArray = null;
                }
                childProxy.configure(childConf);
            }
            Configuration[] instrumentConfs = configuration.getChildren("instrument");
            for (int i = 0; i < instrumentConfs.length; ++i) {
                Configuration instrumentConf = instrumentConfs[i];
                String instrumentName = instrumentConf.getAttribute("name");
                String fullInstrumentName = this.m_name + "." + instrumentName;
                InstrumentProxy instrumentProxy = this.getInstrumentProxy(fullInstrumentName);
                if (instrumentProxy == null) {
                    instrumentProxy = new InstrumentProxy(this, fullInstrumentName, instrumentName);
                    instrumentProxy.enableLogging(this.getLogger());
                    this.m_instrumentManager.incrementInstrumentCount();
                    this.m_instrumentProxies.put(fullInstrumentName, instrumentProxy);
                    this.m_instrumentProxyArray = null;
                    this.m_instrumentDescriptorArray = null;
                }
                instrumentProxy.configure(instrumentConf);
            }
        }
    }

    DefaultInstrumentManagerImpl getInstrumentManager() {
        return this.m_instrumentManager;
    }

    InstrumentableProxy getParentInstrumentableProxy() {
        return this.m_parentInstrumentableProxy;
    }

    boolean isConfigured() {
        return this.m_configured;
    }

    boolean isRegistered() {
        return this.m_registered;
    }

    void setRegistered() {
        if (!this.m_registered) {
            this.m_registered = true;
            this.stateChanged();
        }
    }

    String getName() {
        return this.m_name;
    }

    void setDescription(String description) {
        String oldDescription = this.m_description;
        if (!(oldDescription == description || description != null && description.equals(oldDescription))) {
            this.m_description = description;
            this.stateChanged();
        }
    }

    String getDescription() {
        return this.m_description;
    }

    InstrumentableDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildInstrumentableProxy(InstrumentableProxy childInstrumentableProxy) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_childInstrumentableProxies.put(childInstrumentableProxy.getName(), childInstrumentableProxy);
            this.m_childInstrumentableProxyArray = null;
            this.m_childInstrumentableDescriptorArray = null;
        }
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstrumentableProxy getChildInstrumentableProxy(String childInstrumentableName, boolean create) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            InstrumentableProxy childInstrumentableProxy = (InstrumentableProxy)((Object)this.m_childInstrumentableProxies.get(childInstrumentableName));
            if (childInstrumentableProxy == null && create) {
                int pos = childInstrumentableName.lastIndexOf(46);
                String childName = pos >= 0 ? childInstrumentableName.substring(pos + 1) : childInstrumentableName;
                childInstrumentableProxy = new InstrumentableProxy(this.m_instrumentManager, this, childInstrumentableName, childName);
                childInstrumentableProxy.enableLogging(this.getLogger());
                this.m_instrumentManager.incrementInstrumentableCount();
                this.m_childInstrumentableProxies.put(childInstrumentableName, childInstrumentableProxy);
                this.m_childInstrumentableProxyArray = null;
                this.m_childInstrumentableDescriptorArray = null;
            }
            return childInstrumentableProxy;
        }
    }

    InstrumentableProxy getChildInstrumentableProxy(String childInstrumentableName) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            String name = childInstrumentableName;
            while (true) {
                InstrumentableProxy proxy;
                if ((proxy = (InstrumentableProxy)((Object)this.m_childInstrumentableProxies.get(name))) != null) {
                    return proxy;
                }
                int pos = name.lastIndexOf(46);
                if (pos <= 0) break;
                name = name.substring(0, pos);
            }
            return null;
        }
    }

    InstrumentableProxy[] getChildInstrumentableProxies() {
        InstrumentableProxy[] proxies = this.m_childInstrumentableProxyArray;
        if (proxies == null) {
            proxies = this.updateChildInstrumentableProxyArray();
        }
        return proxies;
    }

    InstrumentableDescriptor[] getChildInstrumentableDescriptors() {
        InstrumentableDescriptor[] descriptors = this.m_childInstrumentableDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateChildInstrumentableDescriptorArray();
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentableProxy[] updateChildInstrumentableProxyArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            InstrumentableProxy[] childInstrumentableProxyArray = new InstrumentableProxy[this.m_childInstrumentableProxies.size()];
            this.m_childInstrumentableProxies.values().toArray(childInstrumentableProxyArray);
            Arrays.sort(childInstrumentableProxyArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((InstrumentableProxy)((Object)o1)).getDescription().compareTo(((InstrumentableProxy)((Object)o2)).getDescription());
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
            this.m_childInstrumentableProxyArray = childInstrumentableProxyArray;
            return childInstrumentableProxyArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentableDescriptor[] updateChildInstrumentableDescriptorArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            InstrumentableProxy[] childInstrumentableProxyArray = this.m_childInstrumentableProxyArray;
            if (childInstrumentableProxyArray == null) {
                childInstrumentableProxyArray = this.updateChildInstrumentableProxyArray();
            }
            InstrumentableDescriptor[] childInstrumentableDescriptorArray = new InstrumentableDescriptor[childInstrumentableProxyArray.length];
            for (int i = 0; i < childInstrumentableProxyArray.length; ++i) {
                childInstrumentableDescriptorArray[i] = childInstrumentableProxyArray[i].getDescriptor();
            }
            this.m_childInstrumentableDescriptorArray = childInstrumentableDescriptorArray;
            return childInstrumentableDescriptorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInstrumentProxy(InstrumentProxy instrumentProxy) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            this.m_instrumentProxies.put(instrumentProxy.getName(), instrumentProxy);
            this.m_instrumentProxyArray = null;
            this.m_instrumentDescriptorArray = null;
        }
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstrumentProxy getInstrumentProxy(String instrumentName, boolean create) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            InstrumentProxy instrumentProxy = (InstrumentProxy)((Object)this.m_instrumentProxies.get(instrumentName));
            if (instrumentProxy == null && create) {
                int pos = instrumentName.lastIndexOf(46);
                String instName = pos >= 0 ? instrumentName.substring(pos + 1) : instrumentName;
                instrumentProxy = new InstrumentProxy(this, instrumentName, instName);
                instrumentProxy.enableLogging(this.getLogger());
                this.m_instrumentManager.incrementInstrumentCount();
                this.m_instrumentProxies.put(instrumentName, instrumentProxy);
                this.m_instrumentProxyArray = null;
                this.m_instrumentDescriptorArray = null;
            }
            return instrumentProxy;
        }
    }

    InstrumentProxy getInstrumentProxy(String instrumentName) {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            String name = instrumentName;
            while (true) {
                InstrumentProxy proxy;
                if ((proxy = (InstrumentProxy)((Object)this.m_instrumentProxies.get(name))) != null) {
                    return proxy;
                }
                int pos = name.lastIndexOf(46);
                if (pos <= 0) break;
                name = name.substring(0, pos);
            }
            return null;
        }
    }

    InstrumentProxy[] getInstrumentProxies() {
        InstrumentProxy[] proxies = this.m_instrumentProxyArray;
        if (proxies == null) {
            proxies = this.updateInstrumentProxyArray();
        }
        return proxies;
    }

    InstrumentDescriptor[] getInstrumentDescriptors() {
        InstrumentDescriptor[] descriptors = this.m_instrumentDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateInstrumentDescriptorArray();
        }
        return descriptors;
    }

    int getStateVersion() {
        return this.m_stateVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentProxy[] updateInstrumentProxyArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            InstrumentProxy[] instrumentProxyArray = new InstrumentProxy[this.m_instrumentProxies.size()];
            this.m_instrumentProxies.values().toArray(instrumentProxyArray);
            Arrays.sort(instrumentProxyArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((InstrumentProxy)((Object)o1)).getDescription().compareTo(((InstrumentProxy)((Object)o2)).getDescription());
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
            this.m_instrumentProxyArray = instrumentProxyArray;
            return instrumentProxyArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentDescriptor[] updateInstrumentDescriptorArray() {
        InstrumentableProxy instrumentableProxy = this;
        synchronized (instrumentableProxy) {
            InstrumentProxy[] instrumentProxyArray = this.m_instrumentProxyArray;
            if (instrumentProxyArray == null) {
                instrumentProxyArray = this.updateInstrumentProxyArray();
            }
            InstrumentDescriptor[] instrumentDescriptorArray = new InstrumentDescriptor[instrumentProxyArray.length];
            for (int i = 0; i < instrumentProxyArray.length; ++i) {
                instrumentDescriptorArray[i] = instrumentProxyArray[i].getDescriptor();
            }
            this.m_instrumentDescriptorArray = instrumentDescriptorArray;
            return instrumentDescriptorArray;
        }
    }

    void writeState(PrintWriter out) {
        InstrumentableProxy[] childProxies = this.getChildInstrumentableProxies();
        for (int i = 0; i < childProxies.length; ++i) {
            childProxies[i].writeState(out);
        }
        InstrumentProxy[] proxies = this.getInstrumentProxies();
        for (int i = 0; i < proxies.length; ++i) {
            proxies[i].writeState(out);
        }
    }

    protected void stateChanged() {
        ++this.m_stateVersion;
        if (this.m_parentInstrumentableProxy == null) {
            this.m_instrumentManager.stateChanged();
        } else {
            this.m_parentInstrumentableProxy.stateChanged();
        }
    }
}

