/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.ColumnImpl;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.CriteriaInterface;
import org.apache.torque.criteria.Join;
import org.apache.torque.criteria.JoinType;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.sql.OrderBy;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.UniqueColumnList;
import org.apache.torque.util.UniqueList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Criteria
implements Serializable,
CriteriaInterface<Criteria> {
    private static final long serialVersionUID = -9001666575933085601L;
    public static final SqlEnum EQUAL = SqlEnum.EQUAL;
    public static final SqlEnum NOT_EQUAL = SqlEnum.NOT_EQUAL;
    public static final SqlEnum ALT_NOT_EQUAL = SqlEnum.ALT_NOT_EQUAL;
    public static final SqlEnum GREATER_THAN = SqlEnum.GREATER_THAN;
    public static final SqlEnum LESS_THAN = SqlEnum.LESS_THAN;
    public static final SqlEnum GREATER_EQUAL = SqlEnum.GREATER_EQUAL;
    public static final SqlEnum LESS_EQUAL = SqlEnum.LESS_EQUAL;
    public static final SqlEnum LIKE = SqlEnum.LIKE;
    public static final SqlEnum NOT_LIKE = SqlEnum.NOT_LIKE;
    public static final SqlEnum ILIKE = SqlEnum.ILIKE;
    public static final SqlEnum NOT_ILIKE = SqlEnum.NOT_ILIKE;
    public static final SqlEnum CUSTOM = SqlEnum.CUSTOM;
    public static final SqlEnum DISTINCT = SqlEnum.DISTINCT;
    public static final SqlEnum IN = SqlEnum.IN;
    public static final SqlEnum NOT_IN = SqlEnum.NOT_IN;
    public static final SqlEnum ALL = SqlEnum.ALL;
    public static final SqlEnum JOIN = SqlEnum.JOIN;
    public static final SqlEnum ISNULL = SqlEnum.ISNULL;
    public static final SqlEnum ISNOTNULL = SqlEnum.ISNOTNULL;
    public static final SqlEnum CURRENT_DATE = SqlEnum.CURRENT_DATE;
    public static final SqlEnum CURRENT_TIME = SqlEnum.CURRENT_TIME;
    public static final JoinType LEFT_JOIN = JoinType.LEFT_JOIN;
    public static final JoinType RIGHT_JOIN = JoinType.RIGHT_JOIN;
    public static final JoinType INNER_JOIN = JoinType.INNER_JOIN;
    private boolean ignoreCase = false;
    private boolean singleRecord = false;
    private final UniqueList<String> selectModifiers = new UniqueList();
    private final UniqueColumnList selectColumns = new UniqueColumnList();
    private final UniqueList<OrderBy> orderByColumns = new UniqueList();
    private final UniqueColumnList groupByColumns = new UniqueColumnList();
    private Criterion having = null;
    private final Map<Column, Criterion> criterionMap = new HashMap<Column, Criterion>();
    private final Map<String, Column> asColumns = new LinkedHashMap<String, Column>();
    private final List<Join> joins = new ArrayList<Join>();
    private String dbName;
    private final String originalDbName;
    private int limit = -1;
    private long offset = 0L;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private static Log log = LogFactory.getLog(Criteria.class);

    public Criteria() {
        this(Torque.getDefaultDB());
    }

    @Deprecated
    public Criteria(int initialCapacity) {
        this(Torque.getDefaultDB());
    }

    public Criteria(String dbName) {
        this.dbName = dbName;
        this.originalDbName = dbName;
    }

    @Deprecated
    public Criteria(String dbName, int initialCapacity) {
        this.dbName = dbName;
        this.originalDbName = dbName;
    }

    public void clear() {
        this.criterionMap.clear();
        this.ignoreCase = false;
        this.singleRecord = false;
        this.selectModifiers.clear();
        this.selectColumns.clear();
        this.orderByColumns.clear();
        this.groupByColumns.clear();
        this.having = null;
        this.asColumns.clear();
        this.joins.clear();
        this.dbName = this.originalDbName;
        this.offset = 0L;
        this.limit = -1;
        this.aliases.clear();
    }

    public Criteria addAsColumn(String name, Column clause) {
        this.asColumns.put(name, clause);
        return this;
    }

    public Criteria addAsColumn(String name, String clause) {
        this.asColumns.put(name, new ColumnImpl(clause));
        return this;
    }

    @Override
    public Map<String, Column> getAsColumns() {
        return this.asColumns;
    }

    @Override
    public Map<String, String> getAliases() {
        return this.aliases;
    }

    @Override
    public Criteria addAlias(String alias, String table) {
        this.aliases.put(alias, table);
        return this;
    }

    @Override
    public String getTableForAlias(String alias) {
        return this.aliases.get(alias);
    }

    @Deprecated
    public boolean containsKey(String table, String column) {
        return this.containsTopLevelColumn(new ColumnImpl(table, column));
    }

    private boolean containsTopLevelColumn(Column column) {
        for (Column candidate : this.criterionMap.keySet()) {
            if (!candidate.getSqlExpression().equals(column.getSqlExpression())) continue;
            return true;
        }
        return false;
    }

    public Criterion getCriterion(Column column) {
        for (Map.Entry<Column, Criterion> mapEntry : this.criterionMap.entrySet()) {
            if (!mapEntry.getKey().getSqlExpression().equals(column.getSqlExpression())) continue;
            return mapEntry.getValue();
        }
        return null;
    }

    public Criterion getCriterion(String column) {
        return this.getCriterion(new ColumnImpl(column));
    }

    public Criterion getCriterion(String table, String column) {
        return this.getCriterion(new ColumnImpl(table, column));
    }

    public Criterion getNewCriterion(Column column, Object value, SqlEnum comparison) {
        return new Criterion(column, value, comparison);
    }

    public Criterion getNewCriterion(String column, Object value, SqlEnum comparison) {
        return new Criterion(new ColumnImpl(column), value, comparison);
    }

    public Criterion getNewCriterion(String table, String column, Object value, SqlEnum comparison) {
        return new Criterion(table, column, value, comparison);
    }

    public Criteria add(Criterion c) {
        this.criterionMap.put(c.getColumn(), c);
        return this;
    }

    public SqlEnum getComparison(Column key) {
        return this.getCriterion(key).getComparison();
    }

    public SqlEnum getComparison(String table, String column) {
        return this.getComparison(new ColumnImpl(table, column));
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public void setDbName(String dbName) {
        this.dbName = dbName == null ? Torque.getDefaultDB() : dbName.trim();
    }

    public boolean getBoolean(Column column) {
        return (Boolean)this.getCriterion(column).getValue();
    }

    public boolean getBoolean(String table, String column) {
        return this.getBoolean(new ColumnImpl(table, column));
    }

    public Date getDate(Column column) {
        return (Date)this.getCriterion(column).getValue();
    }

    public Date getDate(String table, String column) {
        return this.getDate(new ColumnImpl(table, column));
    }

    public double getDouble(Column column) {
        Object obj = this.getCriterion(column).getValue();
        if (obj instanceof String) {
            return new Double((String)obj);
        }
        return (Double)obj;
    }

    public double getDouble(String table, String column) {
        return this.getDouble(new ColumnImpl(table, column));
    }

    public float getFloat(Column column) {
        Object obj = this.getCriterion(column).getValue();
        if (obj instanceof String) {
            return new Float((String)obj).floatValue();
        }
        return ((Float)obj).floatValue();
    }

    public float getFloat(String table, String column) {
        return this.getFloat(new ColumnImpl(table, column));
    }

    public Integer getInteger(Column column) {
        Object obj = this.getCriterion(column).getValue();
        if (obj instanceof String) {
            return new Integer((String)obj);
        }
        return (Integer)obj;
    }

    public Integer getInteger(String table, String column) {
        return this.getInteger(new ColumnImpl(table, column));
    }

    public int getInt(Column column) {
        Object obj = this.getCriterion(column).getValue();
        if (obj instanceof String) {
            return new Integer((String)obj);
        }
        return (Integer)obj;
    }

    public int getInt(String table, String column) {
        return this.getInt(new ColumnImpl(table, column));
    }

    public BigDecimal getBigDecimal(Column column) {
        Object obj = this.getCriterion(column).getValue();
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        return (BigDecimal)obj;
    }

    public BigDecimal getBigDecimal(String table, String column) {
        return this.getBigDecimal(new ColumnImpl(table, column));
    }

    public long getLong(Column column) {
        Object obj = this.getCriterion(column).getValue();
        if (obj instanceof String) {
            return new Long((String)obj);
        }
        return (Long)obj;
    }

    public long getLong(String table, String column) {
        return this.getLong(new ColumnImpl(table, column));
    }

    public String getString(Column column) {
        return (String)this.getCriterion(column).getValue();
    }

    public String getString(String table, String column) {
        return this.getString(new ColumnImpl(table, column));
    }

    public List<Object> getList(Column column) {
        return (List)this.getCriterion(column).getValue();
    }

    public List<Object> getList(String table, String column) {
        return this.getList(new ColumnImpl(table, column));
    }

    public Object getValue(Column column) {
        return this.getCriterion(column).getValue();
    }

    public Object getValue(String table, String column) {
        return this.getValue(new ColumnImpl(table, column));
    }

    public ObjectKey getObjectKey(Column column) {
        return (ObjectKey)this.getCriterion(column).getValue();
    }

    public ObjectKey getObjectKey(String table, String column) {
        return this.getObjectKey(new ColumnImpl(table, column));
    }

    @Deprecated
    public Object get(Column key) {
        return this.getValue(key);
    }

    public boolean isEmpty() {
        return this.criterionMap.isEmpty();
    }

    @Deprecated
    public int size() {
        return this.criterionMap.size();
    }

    public Collection<Criterion> values() {
        return this.criterionMap.values();
    }

    @Deprecated
    public Object put(Column column, Object value) {
        return this.add(column, value);
    }

    public synchronized void putAll(Map<Column, Criterion> t) {
        for (Map.Entry<Column, Criterion> e : t.entrySet()) {
            Criterion val = e.getValue();
            this.criterionMap.put(e.getKey(), val);
        }
    }

    public Criteria add(Column column, Object value) {
        this.add(column, value, EQUAL);
        return this;
    }

    public Criteria add(Column column, Object value, SqlEnum comparison) {
        this.criterionMap.put(column, new Criterion(column, value, comparison));
        return this;
    }

    public Criteria add(String column, Object value) {
        this.add(column, value, EQUAL);
        return this;
    }

    public Criteria add(String column, Object value, SqlEnum comparison) {
        ColumnImpl columnImpl = new ColumnImpl(column);
        this.criterionMap.put(columnImpl, new Criterion(columnImpl, value, comparison));
        return this;
    }

    public Criteria add(String table, String column, Object value) {
        this.add(table, column, value, EQUAL);
        return this;
    }

    public Criteria add(String table, String column, Object value, SqlEnum comparison) {
        ColumnImpl columnImpl = new ColumnImpl(table, column);
        this.criterionMap.put(columnImpl, new Criterion(columnImpl, value, comparison));
        return this;
    }

    public Criteria addDate(Column column, int year, int month, int day) {
        this.add(column, (Object)new GregorianCalendar(year, month, day).getTime());
        return this;
    }

    public Criteria addDate(Column column, int year, int month, int date, SqlEnum comparison) {
        this.add(column, (Object)new GregorianCalendar(year, month, date).getTime(), comparison);
        return this;
    }

    public Criteria addDate(String column, int year, int month, int day) {
        this.add(column, (Object)new GregorianCalendar(year, month, day).getTime());
        return this;
    }

    public Criteria addDate(String column, int year, int month, int date, SqlEnum comparison) {
        this.add(column, (Object)new GregorianCalendar(year, month, date).getTime(), comparison);
        return this;
    }

    public Criteria addJoin(Column left, Column right) {
        return this.addJoin(left, right, null);
    }

    public Criteria addJoin(Column left, Column right, JoinType operator) {
        this.joins.add(new Join(left, right, EQUAL, operator));
        return this;
    }

    public Criteria addJoin(String left, String right) {
        return this.addJoin(left, right, null);
    }

    public Criteria addJoin(String left, String right, JoinType operator) {
        this.joins.add(new Join(new ColumnImpl(left), new ColumnImpl(right), EQUAL, operator));
        return this;
    }

    @Override
    public List<Join> getJoins() {
        return this.joins;
    }

    public Criteria addIn(Column column, Object[] values) {
        this.add(column, (Object)values, IN);
        return this;
    }

    public Criteria addIn(String column, Object[] values) {
        this.add(column, (Object)values, IN);
        return this;
    }

    public Criteria addIn(Column column, Collection<?> values) {
        this.add(column, values, IN);
        return this;
    }

    public Criteria addIn(String column, Collection<?> values) {
        this.add(column, values, IN);
        return this;
    }

    public Criteria addNotIn(Column column, Object[] values) {
        this.add(column, (Object)values, NOT_IN);
        return this;
    }

    public Criteria addNotIn(String column, Object[] values) {
        this.add(column, (Object)values, NOT_IN);
        return this;
    }

    public Criteria addNotIn(Column column, Collection<?> values) {
        this.add(column, values, NOT_IN);
        return this;
    }

    public Criteria addNotIn(String column, Collection<?> values) {
        this.add(column, values, NOT_IN);
        return this;
    }

    @Override
    public void setAll() {
        this.selectModifiers.add(ALL.toString());
    }

    @Override
    public void setDistinct() {
        this.selectModifiers.add(DISTINCT.toString());
    }

    public Criteria setIgnoreCase(boolean b) {
        this.ignoreCase = b;
        return this;
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Criteria setSingleRecord(boolean b) {
        this.singleRecord = b;
        return this;
    }

    @Override
    public boolean isSingleRecord() {
        return this.singleRecord;
    }

    @Override
    public Criteria setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public Criteria setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public Criteria addSelectColumn(Column column) {
        this.selectColumns.add(column);
        return this;
    }

    public Criteria addSelectColumn(String column) {
        this.selectColumns.add(new ColumnImpl(column));
        return this;
    }

    @Override
    public UniqueColumnList getSelectColumns() {
        return this.selectColumns;
    }

    @Override
    public UniqueList<String> getSelectModifiers() {
        return this.selectModifiers;
    }

    public Criteria addGroupByColumn(Column groupBy) {
        this.groupByColumns.add(groupBy);
        return this;
    }

    public Criteria addGroupByColumn(String groupBy) {
        this.groupByColumns.add(new ColumnImpl(groupBy));
        return this;
    }

    public Criteria addAscendingOrderByColumn(Column column) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.ASC, false));
        return this;
    }

    public Criteria addAscendingOrderByColumn(Column column, boolean ignoreCase) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.ASC, ignoreCase));
        return this;
    }

    public Criteria addAscendingOrderByColumn(String column) {
        this.orderByColumns.add(new OrderBy(new ColumnImpl(column), SqlEnum.ASC, false));
        return this;
    }

    public Criteria addDescendingOrderByColumn(Column column) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.DESC, false));
        return this;
    }

    public Criteria addDescendingOrderByColumn(Column column, boolean ignoreCase) {
        this.orderByColumns.add(new OrderBy(column, SqlEnum.DESC, ignoreCase));
        return this;
    }

    public Criteria addDescendingOrderByColumn(String column) {
        this.orderByColumns.add(new OrderBy(new ColumnImpl(column), SqlEnum.DESC, false));
        return this;
    }

    @Override
    public UniqueList<OrderBy> getOrderByColumns() {
        return this.orderByColumns;
    }

    @Override
    public UniqueColumnList getGroupByColumns() {
        return this.groupByColumns;
    }

    public Criterion getHaving() {
        return this.having;
    }

    public Object remove(Column key) {
        Iterator<Map.Entry<Column, Criterion>> entryIt = this.criterionMap.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry<Column, Criterion> entry = entryIt.next();
            if (!entry.getKey().getSqlExpression().equals(key.getSqlExpression())) continue;
            entryIt.remove();
            return entry.getValue().getValue();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Criteria:: ");
        for (Column key : this.keySet()) {
            sb.append(key).append("<=>").append(this.criterionMap.get(key)).append(":  ");
        }
        try {
            Query query = SqlBuilder.buildQuery(this);
            sb.append("\nCurrent Query SQL (may not be complete or applicable): ").append(query.getDisplayString());
        }
        catch (Exception exc) {
            log.debug((Object)"Exception when evaluating a Criteria", (Throwable)exc);
        }
        return sb.toString();
    }

    public Set<Column> keySet() {
        return this.criterionMap.keySet();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Criteria criteria = (Criteria)object;
        if (this.criterionMap.size() != criteria.criterionMap.size()) {
            return false;
        }
        if (!(this.offset == criteria.getOffset() && this.limit == criteria.getLimit() && this.ignoreCase == criteria.isIgnoreCase() && this.singleRecord == criteria.isSingleRecord() && this.dbName.equals(criteria.getDbName()) && this.selectModifiers.equals(criteria.getSelectModifiers()) && this.selectColumns.equals(criteria.getSelectColumns()) && this.orderByColumns.equals(criteria.getOrderByColumns()) && ((Object)this.aliases).equals(criteria.getAliases()) && ((Object)this.asColumns).equals(criteria.getAsColumns()) && ((Object)this.joins).equals(criteria.getJoins()))) {
            return false;
        }
        for (Column key : criteria.keySet()) {
            if (this.containsTopLevelColumn(key)) {
                Criterion b;
                Criterion a = this.getCriterion(key);
                if (a.equals(b = criteria.getCriterion(key))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 16;
        result = 37 * result + Long.valueOf(this.offset).hashCode();
        result = 37 * result + this.limit;
        result = 37 * result + (this.ignoreCase ? 0 : 1);
        result = 37 * result + (this.singleRecord ? 0 : 1);
        result = 37 * result + this.dbName.hashCode();
        result = 37 * result + this.selectModifiers.hashCode();
        result = 37 * result + this.selectColumns.hashCode();
        result = 37 * result + this.orderByColumns.hashCode();
        result = 37 * result + ((Object)this.aliases).hashCode();
        result = 37 * result + ((Object)this.asColumns).hashCode();
        result = 37 * result + ((Object)this.joins).hashCode();
        result = 37 * result + ((Object)this.criterionMap).hashCode();
        return result;
    }

    public Criteria addHaving(Criterion having) {
        this.having = having;
        return this;
    }

    public Criteria and(Criterion c) {
        Criterion oc = this.getCriterion(c.getColumn());
        if (oc == null) {
            this.add(c);
        } else {
            oc.and(c);
        }
        return this;
    }

    public Criteria and(Column column, Object value) {
        this.and(column, value, EQUAL);
        return this;
    }

    public Criteria and(Column column, Object value, SqlEnum comparison) {
        Criterion oc = this.getCriterion(column);
        Criterion nc = new Criterion(column, value, comparison);
        if (oc == null) {
            this.criterionMap.put(column, nc);
        } else {
            oc.and(nc);
        }
        return this;
    }

    public Criteria and(String column, Object value) {
        return this.and(column, value, EQUAL);
    }

    public Criteria and(String column, Object value, SqlEnum comparison) {
        ColumnImpl columnImpl = new ColumnImpl(column);
        return this.and(columnImpl, value, comparison);
    }

    @Deprecated
    public Criteria and(String table, String column, Object value) {
        this.and(table, column, value, EQUAL);
        return this;
    }

    @Deprecated
    public Criteria and(String table, String column, Object value, SqlEnum comparison) {
        Criterion oc = this.getCriterion(table, column);
        Criterion nc = new Criterion(table, column, value, comparison);
        if (oc == null) {
            this.criterionMap.put(new ColumnImpl(table, column), nc);
        } else {
            oc.and(nc);
        }
        return this;
    }

    public Criteria andDate(Column column, int year, int month, int date) {
        this.and(column, (Object)new GregorianCalendar(year, month, date).getTime());
        return this;
    }

    public Criteria andDate(Column column, int year, int month, int date, SqlEnum comparison) {
        this.and(column, (Object)new GregorianCalendar(year, month, date).getTime(), comparison);
        return this;
    }

    public Criteria andDate(String column, int year, int month, int date) {
        this.and(column, (Object)new GregorianCalendar(year, month, date).getTime());
        return this;
    }

    public Criteria andDate(String column, int year, int month, int date, SqlEnum comparison) {
        this.and(column, (Object)new GregorianCalendar(year, month, date).getTime(), comparison);
        return this;
    }

    public Criteria andIn(Column column, Object[] values) {
        this.and(column, (Object)values, IN);
        return this;
    }

    public Criteria andIn(String column, Object[] values) {
        return this.and(column, (Object)values, IN);
    }

    public Criteria andIn(Column column, Collection<?> values) {
        this.and(column, values, IN);
        return this;
    }

    public Criteria andIn(String column, Collection<?> values) {
        return this.and(column, values, IN);
    }

    public Criteria andNotIn(Column column, Object[] values) {
        this.and(column, (Object)values, NOT_IN);
        return this;
    }

    public Criteria andNotIn(String column, Object[] values) {
        ColumnImpl columnImpl = new ColumnImpl(column);
        return this.and(columnImpl, (Object)values, NOT_IN);
    }

    public Criteria andNotIn(Column column, Collection<?> values) {
        this.and(column, values, NOT_IN);
        return this;
    }

    public Criteria andNotIn(String column, Collection<?> values) {
        return this.and(column, values, NOT_IN);
    }

    public Criteria or(Criterion c) {
        Criterion oc = this.getCriterion(c.getColumn());
        if (oc == null) {
            this.add(c);
        } else {
            oc.or(c);
        }
        return this;
    }

    public Criteria or(Column column, Object value) {
        this.or(column, value, EQUAL);
        return this;
    }

    public Criteria or(String column, Object value) {
        this.or(column, value, EQUAL);
        return this;
    }

    public Criteria or(Column column, Object value, SqlEnum comparison) {
        Criterion oc = this.getCriterion(column);
        Criterion nc = new Criterion(column, value, comparison);
        if (oc == null) {
            this.criterionMap.put(column, nc);
        } else {
            oc.or(nc);
        }
        return this;
    }

    public Criteria or(String column, Object value, SqlEnum comparison) {
        return this.or(new ColumnImpl(column), value, comparison);
    }

    @Deprecated
    public Criteria or(String table, String column, Object value) {
        this.or(table, column, value, EQUAL);
        return this;
    }

    @Deprecated
    public Criteria or(String table, String column, Object value, SqlEnum comparison) {
        Criterion oc = this.getCriterion(table, column);
        Criterion nc = new Criterion(table, column, value, comparison);
        if (oc == null) {
            this.criterionMap.put(new ColumnImpl(table, column), nc);
        } else {
            oc.or(nc);
        }
        return this;
    }

    public Criteria orDate(Column column, int year, int month, int date) {
        this.or(column, (Object)new GregorianCalendar(year, month, date));
        return this;
    }

    public Criteria orDate(String column, int year, int month, int date) {
        return this.or(column, (Object)new GregorianCalendar(year, month, date));
    }

    public Criteria orDate(Column column, int year, int month, int date, SqlEnum comparison) {
        this.or(column, (Object)new GregorianCalendar(year, month, date), comparison);
        return this;
    }

    public Criteria orDate(String column, int year, int month, int date, SqlEnum comparison) {
        return this.or(column, (Object)new GregorianCalendar(year, month, date), comparison);
    }

    public Criteria orIn(Column column, Object[] values) {
        this.or(column, (Object)values, IN);
        return this;
    }

    public Criteria orIn(String column, Object[] values) {
        return this.or(column, (Object)values, IN);
    }

    public Criteria orIn(Column column, Collection<?> values) {
        this.or(column, values, IN);
        return this;
    }

    public Criteria orIn(String column, Collection<?> values) {
        return this.or(column, values, IN);
    }

    public Criteria orNotIn(Column column, Object[] values) {
        this.or(column, (Object)values, NOT_IN);
        return this;
    }

    public Criteria orNotIn(String column, Object[] values) {
        return this.or(column, (Object)values, NOT_IN);
    }

    public Criteria orNotIn(Column column, Collection<?> values) {
        this.or(column, values, NOT_IN);
        return this;
    }

    public Criteria orNotIn(String column, Collection<?> values) {
        return this.or(column, values, NOT_IN);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Criterion
    implements Serializable {
        private static final long serialVersionUID = 7157097965404611710L;
        public static final String AND = " AND ";
        public static final String OR = " OR ";
        private Object value;
        private SqlEnum comparison;
        private Column column;
        private boolean ignoreStringCase = false;
        private final List<Criterion> clauses = new ArrayList<Criterion>();
        private final List<String> conjunctions = new ArrayList<String>();

        Criterion(String table, String column, Object val, SqlEnum comp) {
            this.value = val;
            this.setComparison(comp);
            this.column = new ColumnImpl(table, column);
        }

        Criterion(Column column, Object val, SqlEnum comp) {
            this.value = val;
            this.setComparison(comp);
            this.setColumn(column);
        }

        Criterion(String table, String column, Object val) {
            this(table, column, val, EQUAL);
        }

        Criterion(Column column, Object val) {
            this(column, val, EQUAL);
        }

        private void setColumn(Column column) {
            if (column == null) {
                throw new NullPointerException("column must not be null");
            }
            this.column = column;
        }

        public Column getColumn() {
            return this.column;
        }

        private void setComparison(SqlEnum comparison) {
            if (comparison == null) {
                throw new NullPointerException("comparison must not be null");
            }
            this.comparison = comparison;
        }

        public SqlEnum getComparison() {
            return this.comparison;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Criterion setIgnoreCase(boolean b) {
            this.ignoreStringCase = b;
            return this;
        }

        public boolean isIgnoreCase() {
            return this.ignoreStringCase;
        }

        public List<Criterion> getClauses() {
            return Collections.unmodifiableList(this.clauses);
        }

        public List<String> getConjunctions() {
            return Collections.unmodifiableList(this.conjunctions);
        }

        public Criterion and(Criterion criterion) {
            this.clauses.add(criterion);
            this.conjunctions.add(AND);
            return this;
        }

        public Criterion or(Criterion criterion) {
            this.clauses.add(criterion);
            this.conjunctions.add(OR);
            return this;
        }

        public void appendTo(StringBuffer sb) throws TorqueException {
            if (this.column == null) {
                return;
            }
            Criterion clause = null;
            for (int j = 0; j < this.clauses.size(); ++j) {
                sb.append('(');
            }
            if (CUSTOM == this.comparison) {
                if (this.value != null && !"".equals(this.value)) {
                    sb.append((String)this.value);
                }
            } else {
                String field = this.column.getSqlExpression();
                sb.append(field).append(this.comparison).append(this.value);
            }
            for (int i = 0; i < this.clauses.size(); ++i) {
                sb.append(this.conjunctions.get(i));
                clause = this.clauses.get(i);
                clause.appendTo(sb);
                sb.append(')');
            }
        }

        public String toString() {
            if (this.column == null) {
                return "";
            }
            StringBuffer expr = new StringBuffer();
            try {
                this.appendTo(expr);
            }
            catch (TorqueException e) {
                return "Criterion cannot be evaluated";
            }
            return expr.toString();
        }

        public boolean equals(Object obj) {
            boolean isEquiv;
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Criterion)) {
                return false;
            }
            Criterion crit = (Criterion)obj;
            boolean bl = isEquiv = this.column.getSqlExpression().equals(crit.getColumn().getSqlExpression()) && this.comparison.equals(crit.getComparison());
            if (isEquiv) {
                Object b = crit.getValue();
                isEquiv = this.value instanceof Object[] && b instanceof Object[] ? (isEquiv &= Arrays.equals((Object[])this.value, (Object[])b)) : (this.value instanceof int[] && b instanceof int[] ? (isEquiv &= Arrays.equals((int[])this.value, (int[])b)) : (isEquiv &= this.value.equals(b)));
            }
            isEquiv &= this.clauses.size() == crit.getClauses().size();
            for (int i = 0; i < this.clauses.size(); ++i) {
                isEquiv &= this.conjunctions.get(i).equals(crit.getConjunctions().get(i));
                isEquiv &= this.clauses.get(i).equals(crit.getClauses().get(i));
            }
            return isEquiv;
        }

        public int hashCode() {
            int h = this.value.hashCode() ^ this.comparison.hashCode();
            h ^= this.column.getSqlExpression().hashCode();
            for (int i = 0; i < this.clauses.size(); ++i) {
                h ^= this.clauses.get(i).hashCode();
            }
            return h;
        }

        public List<String> getAllTables() {
            UniqueList<String> tables = new UniqueList<String>();
            this.addCriterionTable(this, tables);
            return tables;
        }

        private void addCriterionTable(Criterion c, UniqueList<String> s) {
            if (c != null) {
                s.add(c.getColumn().getTableName());
                for (int i = 0; i < c.getClauses().size(); ++i) {
                    this.addCriterionTable(c.getClauses().get(i), s);
                }
            }
        }

        public Criterion[] getAttachedCriterion() {
            ArrayList<Criterion> crits = new ArrayList<Criterion>();
            this.traverseCriterion(this, crits);
            Criterion[] crita = new Criterion[crits.size()];
            for (int i = 0; i < crits.size(); ++i) {
                crita[i] = crits.get(i);
            }
            return crita;
        }

        private void traverseCriterion(Criterion c, List<Criterion> a) {
            if (c != null) {
                a.add(c);
                for (int i = 0; i < c.getClauses().size(); ++i) {
                    this.traverseCriterion(c.getClauses().get(i), a);
                }
            }
        }
    }
}

