/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.fulcrum.intake.validator.NumberValidator;

public class BigDecimalValidator
extends NumberValidator<BigDecimal> {
    public BigDecimalValidator() {
        this.invalidNumberMessage = "Entry was not a valid BigDecimal";
    }

    @Override
    protected BigDecimal parseNumber(String stringValue, Locale locale) throws NumberFormatException {
        NumberFormat nf = NumberFormat.getInstance(locale);
        try {
            Number number = nf.parse(stringValue);
            return new BigDecimal(number.doubleValue());
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }
}

