/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.jobs.NoOpJob;
import org.quartz.utils.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobBuilder {
    private JobKey key;
    private String description;
    private Class<? extends Job> jobClass = NoOpJob.class;
    private boolean durability;
    private boolean shouldRecover;
    private JobDataMap jobDataMap = new JobDataMap();

    private JobBuilder() {
    }

    public static JobBuilder newJob() {
        return new JobBuilder();
    }

    public static JobBuilder newJob(Class<? extends Job> jobClass) {
        JobBuilder b = new JobBuilder();
        b.ofType(jobClass);
        return b;
    }

    public JobDetail build() {
        JobDetailImpl job = new JobDetailImpl();
        job.setJobClass(this.jobClass);
        job.setDescription(this.description);
        if (this.key == null) {
            this.key = new JobKey(Key.createUniqueName(null), null);
        }
        job.setKey(this.key);
        job.setDurability(this.durability);
        job.setRequestsRecovery(this.shouldRecover);
        if (!this.jobDataMap.isEmpty()) {
            job.setJobDataMap(this.jobDataMap);
        }
        return job;
    }

    public JobBuilder withIdentity(String name) {
        this.key = new JobKey(name, null);
        return this;
    }

    public JobBuilder withIdentity(String name, String group) {
        this.key = new JobKey(name, group);
        return this;
    }

    public JobBuilder withIdentity(JobKey key) {
        this.key = key;
        return this;
    }

    public JobBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public JobBuilder ofType(Class<? extends Job> jobClass) {
        this.jobClass = jobClass;
        return this;
    }

    public JobBuilder requestRecovery() {
        this.shouldRecover = true;
        return this;
    }

    public JobBuilder requestRecovery(boolean shouldRecover) {
        this.shouldRecover = shouldRecover;
        return this;
    }

    public JobBuilder storeDurably() {
        this.durability = true;
        return this;
    }

    public JobBuilder storeDurably(boolean durability) {
        this.durability = durability;
        return this;
    }

    public JobBuilder usingJobData(String key, String value) {
        this.jobDataMap.put(key, value);
        return this;
    }

    public JobBuilder usingJobData(String key, Integer value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public JobBuilder usingJobData(String key, Long value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public JobBuilder usingJobData(String key, Float value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public JobBuilder usingJobData(String key, Double value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public JobBuilder usingJobData(String key, Boolean value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public JobBuilder usingJobData(JobDataMap newJobDataMap) {
        for (Object key : this.jobDataMap.keySet()) {
            newJobDataMap.put(key, this.jobDataMap.get(key));
        }
        this.jobDataMap = newJobDataMap;
        return this;
    }
}

