/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.osgi.service.importer.ImportedOsgiServiceProxy;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.support.AbstractServiceImporterProxyFactoryBean;
import org.springframework.osgi.service.importer.support.AbstractServiceProxyCreator;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.osgi.service.importer.support.DisposableBeanRunnableAdapter;
import org.springframework.osgi.service.importer.support.internal.aop.ProxyPlusCallback;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceDynamicInterceptor;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceInvoker;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceProviderTCCLInterceptor;
import org.springframework.osgi.service.importer.support.internal.controller.ImporterController;
import org.springframework.osgi.service.importer.support.internal.controller.ImporterInternalActions;
import org.springframework.osgi.service.importer.support.internal.dependency.ImporterStateListener;
import org.springframework.osgi.service.importer.support.internal.support.RetryTemplate;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class OsgiServiceProxyFactoryBean
extends AbstractServiceImporterProxyFactoryBean
implements ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog((Class)OsgiServiceProxyFactoryBean.class);
    private long retryTimeout;
    private RetryTemplate retryTemplate;
    private ImportedOsgiServiceProxy proxy;
    private Runnable destructionCallback;
    private ApplicationEventPublisher applicationEventPublisher;
    private final List stateListeners = Collections.synchronizedList(new ArrayList(4));
    private final ImporterInternalActions controller;
    private boolean mandatory;
    private final Object monitor = new Object();

    public OsgiServiceProxyFactoryBean() {
        this.controller = new ImporterController(new Executor());
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.getCardinality() == null) {
            this.setCardinality(Cardinality.C_1__1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getObjectType() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.proxy != null) {
                return this.proxy.getClass();
            }
            Object[] intfs = this.getInterfaces();
            if (!ObjectUtils.isEmpty((Object[])intfs)) {
                for (int index = 0; index < intfs.length; ++index) {
                    if (((Class)intfs[index]).isInterface()) continue;
                    return null;
                }
                Class[] cls = (Class[])ObjectUtils.addObjectToArray((Object[])intfs, (Object)ImportedOsgiServiceProxy.class);
                return Proxy.getProxyClass(this.getAopClassLoader(), cls);
            }
        }
        return null;
    }

    public Object getObject() {
        return super.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object createProxy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating a single service proxy ...");
        }
        final ServiceProviderTCCLInterceptor tcclAdvice = new ServiceProviderTCCLInterceptor();
        ServiceProviderTCCLInterceptor.ServiceProviderTCCLListener tcclListener = new ServiceProviderTCCLInterceptor.ServiceProviderTCCLListener(tcclAdvice);
        final ServiceDynamicInterceptor lookupAdvice = new ServiceDynamicInterceptor(this.getBundleContext(), ClassUtils.getParticularClass(this.getInterfaces()).getName(), this.getUnifiedFilter(), this.getAopClassLoader());
        lookupAdvice.setRequiredAtStartup(this.getCardinality().isMandatory());
        OsgiServiceLifecycleListener[] listeners = this.addListener(this.getListeners(), tcclListener);
        lookupAdvice.setListeners(listeners);
        Object object = this.monitor;
        synchronized (object) {
            lookupAdvice.setRetryTimeout(this.retryTimeout);
            this.retryTemplate = lookupAdvice.getRetryTemplate();
        }
        lookupAdvice.setApplicationEventPublisher(this.applicationEventPublisher);
        lookupAdvice.setStateListeners(this.stateListeners);
        lookupAdvice.setServiceImporter(this);
        lookupAdvice.setServiceImporterName(this.getBeanName());
        AbstractServiceProxyCreator creator = new AbstractServiceProxyCreator(this.getInterfaces(), this.getAopClassLoader(), this.getBeanClassLoader(), this.getBundleContext(), this.getContextClassLoader()){

            ServiceInvoker createDispatcherInterceptor(ServiceReference reference) {
                return lookupAdvice;
            }

            Advice createServiceProviderTCCLAdvice(ServiceReference reference) {
                return tcclAdvice;
            }
        };
        ProxyPlusCallback proxyPlusCallback = creator.createServiceProxy(lookupAdvice.getServiceReference());
        Object object2 = this.monitor;
        synchronized (object2) {
            this.proxy = proxyPlusCallback.proxy;
            this.destructionCallback = new DisposableBeanRunnableAdapter(proxyPlusCallback.destructionCallback);
        }
        lookupAdvice.setProxy(this.proxy);
        lookupAdvice.afterPropertiesSet();
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable getProxyDestructionCallback() {
        Object object = this.monitor;
        synchronized (object) {
            return this.destructionCallback;
        }
    }

    private OsgiServiceLifecycleListener[] addListener(OsgiServiceLifecycleListener[] listeners, OsgiServiceLifecycleListener listener) {
        int size2 = listeners == null ? 1 : listeners.length + 1;
        OsgiServiceLifecycleListener[] list = new OsgiServiceLifecycleListener[size2];
        list[0] = listener;
        if (listeners != null) {
            System.arraycopy(listeners, 0, list, 1, listeners.length);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long timeoutInMillis) {
        RetryTemplate rt;
        Object object = this.monitor;
        synchronized (object) {
            this.retryTimeout = timeoutInMillis;
            rt = this.retryTemplate;
        }
        if (rt != null) {
            rt.reset(timeoutInMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout() {
        Object object = this.monitor;
        synchronized (object) {
            return this.retryTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCardinality(Cardinality cardinality) {
        Assert.notNull((Object)((Object)cardinality));
        Assert.isTrue((boolean)cardinality.isSingle(), (String)"only singular cardinality ('X..1') accepted");
        super.setCardinality(cardinality);
        Object object = this.monitor;
        synchronized (object) {
            this.mandatory = cardinality.isMandatory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        Object object = this.monitor;
        synchronized (object) {
            this.applicationEventPublisher = applicationEventPublisher;
        }
    }

    private class Executor
    implements ImporterInternalActions {
        private Executor() {
        }

        public void addStateListener(ImporterStateListener stateListener) {
            OsgiServiceProxyFactoryBean.this.stateListeners.add(stateListener);
        }

        public void removeStateListener(ImporterStateListener stateListener) {
            OsgiServiceProxyFactoryBean.this.stateListeners.remove(stateListener);
        }

        public boolean isSatisfied() {
            if (!OsgiServiceProxyFactoryBean.this.mandatory) {
                return true;
            }
            return OsgiServiceProxyFactoryBean.this.proxy == null ? true : OsgiServiceProxyFactoryBean.this.proxy.getServiceReference().getBundle() != null;
        }
    }
}

