/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.messenger.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.messenger.Status;
import org.apache.qpid.proton.messenger.impl.StoreEntry;

class Store {
    private static final Accepted ACCEPTED = Accepted.getInstance();
    private static final Rejected REJECTED = new Rejected();
    private LinkedList<StoreEntry> _store = new LinkedList();
    private HashMap<String, LinkedList<StoreEntry>> _stream = new HashMap();
    int _window;
    int _lwm;
    int _hwm;
    private HashMap<Integer, StoreEntry> _tracked = new HashMap();

    Store() {
    }

    private boolean isTracking(Integer id) {
        return id != null && id - this._lwm >= 0 && this._hwm - id > 0;
    }

    int size() {
        return this._store.size();
    }

    int getWindow() {
        return this._window;
    }

    void setWindow(int window) {
        this._window = window;
    }

    StoreEntry put(String address) {
        if (address == null) {
            address = "";
        }
        StoreEntry entry = new StoreEntry(this, address);
        this._store.add(entry);
        LinkedList<StoreEntry> list = this._stream.get(address);
        if (list != null) {
            list.add(entry);
        } else {
            list = new LinkedList();
            list.add(entry);
            this._stream.put(address, list);
        }
        entry.stored();
        return entry;
    }

    StoreEntry get(String address) {
        if (address != null) {
            LinkedList<StoreEntry> list = this._stream.get(address);
            if (list != null) {
                return list.peekFirst();
            }
        } else {
            return this._store.peekFirst();
        }
        return null;
    }

    StoreEntry getEntry(int id) {
        return this._tracked.get(id);
    }

    Iterator<StoreEntry> trackedEntries() {
        return this._tracked.values().iterator();
    }

    void freeEntry(StoreEntry entry) {
        if (entry.isStored()) {
            this._store.remove(entry);
            LinkedList<StoreEntry> list = this._stream.get(entry.getAddress());
            if (list != null) {
                list.remove(entry);
            }
            entry.notStored();
        }
    }

    public int trackEntry(StoreEntry entry) {
        assert (entry.getStore() == this);
        entry.setId(this._hwm++);
        this._tracked.put(entry.getId(), entry);
        this.slideWindow();
        return entry.getId();
    }

    private void slideWindow() {
        if (this._window >= 0) {
            while (this._hwm - this._lwm > this._window) {
                StoreEntry old = this.getEntry(this._lwm);
                if (old != null) {
                    this._tracked.remove(old.getId());
                    Delivery d = old.getDelivery();
                    if (d != null) {
                        if (d.getLocalState() == null) {
                            d.disposition(ACCEPTED);
                        }
                        d.settle();
                    }
                }
                ++this._lwm;
            }
        }
    }

    int update(int id, Status status2, int flags, boolean settle, boolean match) {
        int start2;
        if (!this.isTracking(id)) {
            return 0;
        }
        int i = start2 = (1 & flags) != 0 ? this._lwm : id;
        while (id - i >= 0) {
            StoreEntry e = this.getEntry(i);
            if (e != null) {
                Delivery d = e.getDelivery();
                if (d != null && d.getLocalState() == null) {
                    if (match) {
                        d.disposition(d.getRemoteState());
                    } else {
                        switch (status2) {
                            case ACCEPTED: {
                                d.disposition(ACCEPTED);
                                break;
                            }
                            case REJECTED: {
                                d.disposition(REJECTED);
                                break;
                            }
                        }
                    }
                    e.updated();
                }
                if (settle) {
                    if (d != null) {
                        d.settle();
                    }
                    this._tracked.remove(e.getId());
                }
            }
            ++i;
        }
        while (this._hwm - this._lwm > 0 && !this._tracked.containsKey(this._lwm)) {
            ++this._lwm;
        }
        return 0;
    }
}

