/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transaction.Synchronization;

public class ManagedTransactionContext
extends TransactionContext {
    private final TransactionContext sharedContext;
    private boolean useSharedTxContext;

    public ManagedTransactionContext(TransactionContext sharedContext) {
        super(sharedContext.getConnection());
        this.sharedContext = sharedContext;
        this.setLocalTransactionEventListener(sharedContext.getLocalTransactionEventListener());
    }

    public void setUseSharedTxContext(boolean enable) throws JMSException {
        if (this.isInLocalTransaction() || this.isInXATransaction()) {
            throw new JMSException("The resource is already being used in transaction context.");
        }
        this.useSharedTxContext = enable;
    }

    @Override
    public void begin() throws JMSException {
        if (this.useSharedTxContext) {
            this.sharedContext.begin();
        } else {
            super.begin();
        }
    }

    @Override
    public void commit() throws JMSException {
        if (this.useSharedTxContext) {
            this.sharedContext.commit();
        } else {
            super.commit();
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.commit(xid, onePhase);
        } else {
            super.commit(xid, onePhase);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.end(xid, flags);
        } else {
            super.end(xid, flags);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.forget(xid);
        } else {
            super.forget(xid);
        }
    }

    @Override
    public TransactionId getTransactionId() {
        if (this.useSharedTxContext) {
            return this.sharedContext.getTransactionId();
        }
        return super.getTransactionId();
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.getTransactionTimeout();
        }
        return super.getTransactionTimeout();
    }

    @Override
    public boolean isInLocalTransaction() {
        if (this.useSharedTxContext) {
            return this.sharedContext.isInLocalTransaction();
        }
        return super.isInLocalTransaction();
    }

    @Override
    public boolean isInXATransaction() {
        if (this.useSharedTxContext) {
            return this.sharedContext.isInTransaction();
        }
        return super.isInXATransaction();
    }

    @Override
    public boolean isInTransaction() {
        return this.isInXATransaction() || this.isInLocalTransaction();
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.isSameRM(xaResource);
        }
        return super.isSameRM(xaResource);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.prepare(xid);
        }
        return super.prepare(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.recover(flag);
        }
        return super.recover(flag);
    }

    @Override
    public void rollback() throws JMSException {
        if (this.useSharedTxContext) {
            this.sharedContext.rollback();
        } else {
            super.rollback();
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.rollback(xid);
        } else {
            super.rollback(xid);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.setTransactionTimeout(seconds);
        }
        return super.setTransactionTimeout(seconds);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.start(xid, flags);
        } else {
            super.start(xid, flags);
        }
    }

    @Override
    public void addSynchronization(Synchronization s) {
        if (this.useSharedTxContext) {
            this.sharedContext.addSynchronization(s);
        } else {
            super.addSynchronization(s);
        }
    }
}

