/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.util.InetAddressUtil;

public class PublishedAddressPolicy {
    private String clusterClientUriQuery;
    private PublishedHostStrategy publishedHostStrategy = PublishedHostStrategy.DEFAULT;
    private HashMap<Integer, Integer> portMapping = new HashMap();

    public URI getPublishableConnectURI(TransportConnector connector) throws Exception {
        URI connectorURI = connector.getConnectUri();
        if (connectorURI == null) {
            return null;
        }
        String scheme = connectorURI.getScheme();
        if ("vm".equals(scheme)) {
            return connectorURI;
        }
        String userInfo = this.getPublishedUserInfoValue(connectorURI.getUserInfo());
        String host = this.getPublishedHostValue(connectorURI.getHost());
        int port = connectorURI.getPort();
        if (this.portMapping.containsKey(port)) {
            port = this.portMapping.get(port);
        }
        String path = this.getPublishedPathValue(connectorURI.getPath());
        String fragment = this.getPublishedFragmentValue(connectorURI.getFragment());
        URI publishedURI = new URI(scheme, userInfo, host, port, path, this.getClusterClientUriQuery(), fragment);
        return publishedURI;
    }

    public String getPublishableConnectString(TransportConnector connector) throws Exception {
        return this.getPublishableConnectURI(connector).toString();
    }

    protected String getPublishedHostValue(String uriHostEntry) throws UnknownHostException {
        String result = uriHostEntry;
        if (this.publishedHostStrategy.equals((Object)PublishedHostStrategy.IPADDRESS)) {
            InetAddress address = InetAddress.getByName(uriHostEntry);
            result = address.getHostAddress();
        } else if (this.publishedHostStrategy.equals((Object)PublishedHostStrategy.HOSTNAME)) {
            InetAddress address = InetAddress.getByName(uriHostEntry);
            result = address.isAnyLocalAddress() ? InetAddressUtil.getLocalHostName() : address.getHostName();
        } else if (this.publishedHostStrategy.equals((Object)PublishedHostStrategy.FQDN)) {
            InetAddress address = InetAddress.getByName(uriHostEntry);
            result = address.isAnyLocalAddress() ? InetAddressUtil.getLocalHostName() : address.getCanonicalHostName();
        }
        return result;
    }

    protected String getPublishedPathValue(String uriPathEntry) {
        return uriPathEntry;
    }

    protected String getPublishedFragmentValue(String uriFragmentEntry) {
        return uriFragmentEntry;
    }

    protected String getPublishedUserInfoValue(String uriUserInfoEntry) {
        return uriUserInfoEntry;
    }

    public String getClusterClientUriQuery() {
        return this.clusterClientUriQuery;
    }

    public void setClusterClientUriQuery(String clusterClientUriQuery) {
        this.clusterClientUriQuery = clusterClientUriQuery;
    }

    public PublishedHostStrategy getPublishedHostStrategy() {
        return this.publishedHostStrategy;
    }

    public void setPublishedHostStrategy(PublishedHostStrategy strategy) {
        this.publishedHostStrategy = strategy;
    }

    public void setPublishedHostStrategy(String strategy) {
        this.publishedHostStrategy = PublishedHostStrategy.getValue(strategy);
    }

    public void setPortMapping(HashMap<Integer, Integer> portMapping) {
        this.portMapping = portMapping;
    }

    public static enum PublishedHostStrategy {
        DEFAULT,
        IPADDRESS,
        HOSTNAME,
        FQDN;


        public static PublishedHostStrategy getValue(String value) {
            return PublishedHostStrategy.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
    }
}

