/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.command;

import java.util.Arrays;
import org.apache.karaf.http.core.ServletInfo;
import org.apache.karaf.http.core.ServletService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="http", name="list", description="Lists details for servlets.")
@Service
public class ServletListCommand
implements Action {
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Reference
    private ServletService servletService;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column(new Col("ID"));
        table.column(new Col("Servlet"));
        table.column(new Col("Servlet-Name"));
        table.column(new Col("State"));
        table.column(new Col("Alias"));
        table.column(new Col("Url"));
        for (ServletInfo info : this.servletService.getServlets()) {
            table.addRow().addContent(new Object[]{info.getBundle().getBundleId(), info.getClassName(), info.getName(), info.getStateString(), info.getAlias(), Arrays.toString(info.getUrls())});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }

    public void setServletService(ServletService servletService) {
        this.servletService = servletService;
    }
}

