/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import java.util.Collections;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.felix.http.base.internal.runtime.ResourceInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.util.PatternUtil;
import org.osgi.framework.ServiceReference;

public class ServletInfo
extends WhiteboardServiceInfo<Servlet> {
    private static final String SERVLET_INIT_PREFIX = "servlet.init.";
    private final String name;
    private final String[] patterns;
    private final String[] errorPage;
    private final boolean asyncSupported;
    private final boolean isResource;
    private final Map<String, String> initParams;
    private final String prefix;

    public ServletInfo(ServiceReference<Servlet> ref) {
        super(ref);
        this.name = this.getStringProperty(ref, "osgi.http.whiteboard.servlet.name");
        this.errorPage = this.getStringArrayProperty(ref, "osgi.http.whiteboard.servlet.errorPage");
        this.patterns = this.getStringArrayProperty(ref, "osgi.http.whiteboard.servlet.pattern");
        this.asyncSupported = this.getBooleanProperty(ref, "osgi.http.whiteboard.servlet.asyncSupported");
        this.initParams = this.getInitParams(ref, SERVLET_INIT_PREFIX);
        this.isResource = false;
        this.prefix = null;
    }

    public ServletInfo(ResourceInfo resource) {
        super(ServletInfo.getRef(resource.getServiceReference()));
        this.name = null;
        this.patterns = resource.getPatterns();
        this.errorPage = null;
        this.asyncSupported = false;
        this.initParams = Collections.emptyMap();
        this.isResource = true;
        this.prefix = resource.getPrefix();
    }

    private static ServiceReference getRef(ServiceReference ref) {
        return ref;
    }

    public ServletInfo(String name, String pattern, Map<String, String> initParams) {
        super(Integer.MAX_VALUE);
        this.name = name;
        this.patterns = new String[]{pattern};
        this.initParams = Collections.unmodifiableMap(initParams);
        this.asyncSupported = true;
        this.errorPage = null;
        this.isResource = false;
        this.prefix = null;
    }

    @Override
    public boolean isValid() {
        boolean valid;
        boolean bl = valid = super.isValid() && (!this.isEmpty(this.patterns) || !this.isEmpty(this.errorPage));
        if (valid && this.patterns != null) {
            for (String p : this.patterns) {
                if (PatternUtil.isValidPattern(p)) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public String[] getErrorPage() {
        return this.errorPage;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public Map<String, String> getInitParameters() {
        return this.initParams;
    }

    public boolean isResource() {
        return this.isResource;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

