/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.web.extender.war.internal.WebAppHttpContext;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RegisterWebAppVisitorHS
implements WebAppVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterWebAppVisitorHS.class);
    private final HttpService httpService;
    private HttpContext httpContext;
    private ClassLoader bundleClassLoader;

    RegisterWebAppVisitorHS(HttpService httpService) {
        NullArgumentException.validateNotNull(httpService, "Http Service");
        this.httpService = httpService;
    }

    @Override
    public void visit(WebApp webApp) {
        NullArgumentException.validateNotNull(webApp, "Web app");
        this.bundleClassLoader = new BundleClassLoader(webApp.getBundle());
        this.httpContext = new WebAppHttpContext(this.httpService.createDefaultHttpContext(), webApp.getRootPath(), webApp.getBundle(), webApp.getMimeMappings());
        try {
            LOG.info("Pax Web not available. Skipping context params registration");
            this.httpService.registerResources("/", "", this.httpContext);
        }
        catch (Throwable ignore) {
            LOG.error("Registration exception. Skipping.", ignore);
        }
    }

    @Override
    public void visit(WebAppServlet webAppServlet) {
        NullArgumentException.validateNotNull(webAppServlet, "Web app servlet");
        String[] aliases = webAppServlet.getAliases();
        if (aliases != null && aliases.length > 0) {
            for (String alias : aliases) {
                try {
                    Servlet servlet = RegisterWebAppVisitorHS.newInstance(Servlet.class, this.bundleClassLoader, webAppServlet.getServletClassName());
                    this.httpService.registerServlet(alias, servlet, RegisterWebAppVisitorHS.convertInitParams(webAppServlet.getInitParams()), this.httpContext);
                }
                catch (Throwable ignore) {
                    LOG.error("Registration exception. Skipping.", ignore);
                }
            }
        } else {
            LOG.warn("Servlet [" + webAppServlet + "] does not have any alias. Skipped.");
        }
    }

    @Override
    public void visit(WebAppFilter webAppFilter) {
        LOG.info("Pax Web not available. Skipping filter registration for [" + webAppFilter + "]");
    }

    @Override
    public void visit(WebAppListener webAppListener) {
        LOG.info("Pax Web not available. Skipping listener registration for [" + webAppListener + "]");
    }

    @Override
    public void visit(WebAppErrorPage webAppErrorPage) {
        LOG.info("Pax Web not available. Skipping error page registration for [" + webAppErrorPage + "]");
    }

    @Override
    public void visit(WebAppLoginConfig loginConfig) {
        LOG.info("Pax Web not available. Skipping login config registration for [" + loginConfig + "]");
    }

    @Override
    public void visit(WebAppConstraintMapping constraintMapping) {
        LOG.info("Pax Web not available. Skipping constraint mapping registration for [" + constraintMapping + "]");
    }

    @Override
    public void end() {
    }

    public static <T> T newInstance(Class<T> clazz, ClassLoader classLoader, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return RegisterWebAppVisitorHS.loadClass(clazz, classLoader, className).newInstance();
    }

    public static <T> Class<? extends T> loadClass(Class<T> clazz, ClassLoader classLoader, String className) throws ClassNotFoundException, IllegalAccessException {
        NullArgumentException.validateNotNull(clazz, "Class");
        NullArgumentException.validateNotNull(classLoader, "ClassLoader");
        NullArgumentException.validateNotNull(className, "Servlet Class");
        return classLoader.loadClass(className);
    }

    public static Dictionary<String, String> convertInitParams(WebAppInitParam[] initParams) {
        if (initParams == null || initParams.length == 0) {
            return null;
        }
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        for (WebAppInitParam initParam : initParams) {
            dictionary.put(initParam.getParamName(), initParam.getParamValue());
        }
        return dictionary;
    }
}

