/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.lang.reflect.Array;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSshFuture<T extends SshFuture>
implements SshFuture<T> {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Object CANCELED = new Object();
    private static final Object NULL = new Object();
    private final Object lock;
    private Object listeners;
    private Object result;

    public DefaultSshFuture(Object lock) {
        this.lock = lock != null ? lock : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T await() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.result == null) {
                this.lock.wait();
            }
        }
        return this.asT();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await(unit.toMillis(timeout));
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(timeoutMillis, true);
    }

    @Override
    public T awaitUninterruptibly() {
        try {
            this.await0(Long.MAX_VALUE, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.asT();
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.awaitUninterruptibly(unit.toMillis(timeout));
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0(long timeoutMillis, boolean interruptable) throws InterruptedException {
        long curTime = System.currentTimeMillis();
        long endTime = Long.MAX_VALUE - timeoutMillis < curTime ? Long.MAX_VALUE : curTime + timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null || timeoutMillis <= 0L) {
                return this.result != null;
            }
            do {
                block7: {
                    try {
                        this.lock.wait(endTime - curTime);
                    }
                    catch (InterruptedException e) {
                        if (!interruptable) break block7;
                        throw e;
                    }
                }
                curTime = System.currentTimeMillis();
            } while (this.result == null && curTime < endTime);
            return this.result != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.result != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                return;
            }
            this.result = newValue != null ? newValue : NULL;
            this.lock.notifyAll();
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result == NULL ? null : this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T addListener(SshFutureListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                notifyNow = true;
            } else if (this.listeners == null) {
                this.listeners = listener;
            } else if (this.listeners instanceof SshFutureListener) {
                this.listeners = new Object[]{this.listeners, listener};
            } else {
                Object[] ol = (Object[])this.listeners;
                int l = ol.length;
                Object[] nl = new Object[l + 1];
                System.arraycopy(ol, 0, nl, 0, l);
                nl[l] = listener;
                this.listeners = nl;
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
        return this.asT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeListener(SshFutureListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.result == null && this.listeners != null) {
                if (this.listeners == listener) {
                    this.listeners = null;
                } else {
                    int l = Array.getLength(this.listeners);
                    for (int i = 0; i < l; ++i) {
                        if (Array.get(this.listeners, i) != listener) continue;
                        Array.set(this.listeners, i, null);
                        break;
                    }
                }
            }
        }
        return this.asT();
    }

    private void notifyListeners() {
        if (this.listeners != null) {
            if (this.listeners instanceof SshFutureListener) {
                this.notifyListener(this.asListener(this.listeners));
            } else {
                int l = Array.getLength(this.listeners);
                for (int i = 0; i < l; ++i) {
                    SshFutureListener<T> listener = this.asListener(Array.get(this.listeners, i));
                    if (listener == null) continue;
                    this.notifyListener(listener);
                }
            }
        }
    }

    private void notifyListener(SshFutureListener<T> l) {
        try {
            l.operationComplete(this.asT());
        }
        catch (Throwable t) {
            this.logger.warn("Listener threw an exception", t);
        }
    }

    public boolean isCanceled() {
        return this.getValue() == CANCELED;
    }

    public void cancel() {
        this.setValue(CANCELED);
    }

    private SshFutureListener<T> asListener(Object o) {
        return (SshFutureListener)o;
    }

    private T asT() {
        return (T)this;
    }
}

