/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.nativefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.file.nativefs.NativeFileSystemView;
import org.apache.sshd.common.file.nativefs.NativeSshFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeSshFileNio
extends NativeSshFile {
    @Override
    public boolean doesExist() {
        return Files.exists(this.file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    public NativeSshFileNio(NativeFileSystemView nativeFileSystemView, String fileName, File file, String userName) {
        super(nativeFileSystemView, fileName, file, userName);
    }

    @Override
    public Map<SshFile.Attribute, Object> getAttributes(boolean followLinks) throws IOException {
        String[] attrs = new String[]{"unix:*", "posix:*", "*"};
        Map<String, Object> a = null;
        for (String attr : attrs) {
            try {
                LinkOption[] linkOptionArray;
                Path path = this.file.toPath();
                if (followLinks) {
                    linkOptionArray = new LinkOption[]{};
                } else {
                    LinkOption[] linkOptionArray2 = new LinkOption[1];
                    linkOptionArray = linkOptionArray2;
                    linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
                }
                a = Files.readAttributes(path, attr, linkOptionArray);
                break;
            }
            catch (UnsupportedOperationException e) {
            }
        }
        if (a == null) {
            throw new IllegalStateException();
        }
        HashMap<SshFile.Attribute, Object> map = new HashMap<SshFile.Attribute, Object>();
        map.put(SshFile.Attribute.Size, a.get("size"));
        if (a.containsKey("uid")) {
            map.put(SshFile.Attribute.Uid, a.get("uid"));
        }
        if (a.containsKey("owner")) {
            map.put(SshFile.Attribute.Owner, ((UserPrincipal)a.get("owner")).getName());
        } else {
            map.put(SshFile.Attribute.Owner, this.userName);
        }
        if (a.containsKey("gid")) {
            map.put(SshFile.Attribute.Gid, a.get("gid"));
        }
        if (a.containsKey("group")) {
            map.put(SshFile.Attribute.Group, ((GroupPrincipal)a.get("group")).getName());
        } else {
            map.put(SshFile.Attribute.Group, this.userName);
        }
        if (a.containsKey("nlink")) {
            map.put(SshFile.Attribute.NLink, a.get("nlink"));
        }
        map.put(SshFile.Attribute.IsDirectory, a.get("isDirectory"));
        map.put(SshFile.Attribute.IsRegularFile, a.get("isRegularFile"));
        map.put(SshFile.Attribute.IsSymbolicLink, a.get("isSymbolicLink"));
        map.put(SshFile.Attribute.CreationTime, ((FileTime)a.get("creationTime")).toMillis());
        map.put(SshFile.Attribute.LastModifiedTime, ((FileTime)a.get("lastModifiedTime")).toMillis());
        map.put(SshFile.Attribute.LastAccessTime, ((FileTime)a.get("lastAccessTime")).toMillis());
        if (a.containsKey("permissions")) {
            map.put(SshFile.Attribute.Permissions, this.fromPerms((Set)a.get("permissions")));
        } else {
            EnumSet<SshFile.Permission> p = EnumSet.noneOf(SshFile.Permission.class);
            if (this.isReadable()) {
                p.add(SshFile.Permission.UserRead);
                p.add(SshFile.Permission.GroupRead);
                p.add(SshFile.Permission.OthersRead);
            }
            if (this.isWritable()) {
                p.add(SshFile.Permission.UserWrite);
                p.add(SshFile.Permission.GroupWrite);
                p.add(SshFile.Permission.OthersWrite);
            }
            if (this.isExecutable()) {
                p.add(SshFile.Permission.UserExecute);
                p.add(SshFile.Permission.GroupExecute);
                p.add(SshFile.Permission.OthersExecute);
            }
            map.put(SshFile.Attribute.Permissions, p);
        }
        return map;
    }

    @Override
    public void setAttributes(Map<SshFile.Attribute, Object> attributes) throws IOException {
        HashSet<SshFile.Attribute> unsupported = new HashSet<SshFile.Attribute>();
        block13: for (SshFile.Attribute attribute : attributes.keySet()) {
            String name = null;
            Object value = attributes.get((Object)attribute);
            switch (attribute) {
                case Size: {
                    long newSize = (Long)value;
                    FileChannel outChan = new FileOutputStream(this.file, true).getChannel();
                    outChan.truncate(newSize);
                    outChan.close();
                    continue block13;
                }
                case Uid: {
                    name = "unix:uid";
                    break;
                }
                case Gid: {
                    name = "unix:gid";
                    break;
                }
                case Owner: {
                    name = "posix:owner";
                    value = this.toUser((String)value);
                    break;
                }
                case Group: {
                    name = "posix:group";
                    value = this.toGroup((String)value);
                    break;
                }
                case Permissions: {
                    name = "posix:permissions";
                    value = this.toPerms((EnumSet)value);
                    break;
                }
                case CreationTime: {
                    name = "basic:creationTime";
                    value = FileTime.fromMillis((Long)value);
                    break;
                }
                case LastModifiedTime: {
                    name = "basic:lastModifiedTime";
                    value = FileTime.fromMillis((Long)value);
                    break;
                }
                case LastAccessTime: {
                    name = "basic:lastAccessTime";
                    value = FileTime.fromMillis((Long)value);
                }
            }
            if (name == null || value == null) continue;
            try {
                Files.setAttribute(this.file.toPath(), name, value, LinkOption.NOFOLLOW_LINKS);
            }
            catch (UnsupportedOperationException e) {
                unsupported.add(attribute);
            }
        }
        this.handleUnsupportedAttributes(unsupported);
    }

    @Override
    public String readSymbolicLink() throws IOException {
        Path path = this.file.toPath();
        Path link = Files.readSymbolicLink(path);
        return link.toString();
    }

    @Override
    public void createSymbolicLink(SshFile destination) throws IOException {
        Path link = this.file.toPath();
        Path target = Paths.get(destination.getAbsolutePath(), new String[0]);
        Files.createSymbolicLink(target, link, new FileAttribute[0]);
    }

    private EnumSet<SshFile.Permission> fromPerms(Set<PosixFilePermission> perms) {
        EnumSet<SshFile.Permission> p = EnumSet.noneOf(SshFile.Permission.class);
        for (PosixFilePermission perm : perms) {
            switch (perm) {
                case OWNER_READ: {
                    p.add(SshFile.Permission.UserRead);
                    break;
                }
                case OWNER_WRITE: {
                    p.add(SshFile.Permission.UserWrite);
                    break;
                }
                case OWNER_EXECUTE: {
                    p.add(SshFile.Permission.UserExecute);
                    break;
                }
                case GROUP_READ: {
                    p.add(SshFile.Permission.GroupRead);
                    break;
                }
                case GROUP_WRITE: {
                    p.add(SshFile.Permission.GroupWrite);
                    break;
                }
                case GROUP_EXECUTE: {
                    p.add(SshFile.Permission.GroupExecute);
                    break;
                }
                case OTHERS_READ: {
                    p.add(SshFile.Permission.OthersRead);
                    break;
                }
                case OTHERS_WRITE: {
                    p.add(SshFile.Permission.OthersWrite);
                    break;
                }
                case OTHERS_EXECUTE: {
                    p.add(SshFile.Permission.OthersExecute);
                }
            }
        }
        return p;
    }

    private GroupPrincipal toGroup(String name) throws IOException {
        UserPrincipalLookupService lookupService = this.file.toPath().getFileSystem().getUserPrincipalLookupService();
        return lookupService.lookupPrincipalByGroupName(name);
    }

    private UserPrincipal toUser(String name) throws IOException {
        UserPrincipalLookupService lookupService = this.file.toPath().getFileSystem().getUserPrincipalLookupService();
        return lookupService.lookupPrincipalByName(name);
    }

    private Set<PosixFilePermission> toPerms(EnumSet<SshFile.Permission> perms) {
        HashSet<PosixFilePermission> set = new HashSet<PosixFilePermission>();
        for (SshFile.Permission p : perms) {
            switch (p) {
                case UserRead: {
                    set.add(PosixFilePermission.OWNER_READ);
                    break;
                }
                case UserWrite: {
                    set.add(PosixFilePermission.OWNER_WRITE);
                    break;
                }
                case UserExecute: {
                    set.add(PosixFilePermission.OWNER_EXECUTE);
                    break;
                }
                case GroupRead: {
                    set.add(PosixFilePermission.GROUP_READ);
                    break;
                }
                case GroupWrite: {
                    set.add(PosixFilePermission.GROUP_WRITE);
                    break;
                }
                case GroupExecute: {
                    set.add(PosixFilePermission.GROUP_EXECUTE);
                    break;
                }
                case OthersRead: {
                    set.add(PosixFilePermission.OTHERS_READ);
                    break;
                }
                case OthersWrite: {
                    set.add(PosixFilePermission.OTHERS_WRITE);
                    break;
                }
                case OthersExecute: {
                    set.add(PosixFilePermission.OTHERS_EXECUTE);
                }
            }
        }
        return set;
    }

    @Override
    public OutputStream createOutputStream(long offset) throws IOException {
        Path path = this.file.toPath();
        final SeekableByteChannel sbc = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        if (offset > 0L) {
            sbc.position(offset);
        }
        return new OutputStream(){

            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return;
                }
                sbc.write(ByteBuffer.wrap(b, off, len));
            }

            public void close() throws IOException {
                sbc.close();
            }
        };
    }
}

