/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Dictionary;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenConfigService {
    private final Logger logger = LoggerFactory.getLogger(MavenConfigService.class);
    private final ConfigurationAdmin configurationAdmin;

    public MavenConfigService(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public File getLocalRepository() {
        int index;
        String path = null;
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.ops4j.pax.url.mvn", null);
            if (configuration != null) {
                Dictionary dict = configuration.getProperties();
                path = MavenConfigService.getLocalRepoFromConfig(dict);
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving maven configuration", (Throwable)e);
        }
        if (path == null) {
            path = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
        }
        if ((index = path.indexOf(64)) > 0) {
            return new File(path.substring(index)).getAbsoluteFile();
        }
        return new File(path).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getLocalRepoFromConfig(Dictionary<String, Object> dict) throws XMLStreamException, FileNotFoundException {
        String settings;
        String path = null;
        if (dict != null && (path = (String)dict.get("org.ops4j.pax.url.mvn.localRepository")) == null && (settings = (String)dict.get("org.ops4j.pax.url.mvn.settings")) != null) {
            File file = new File(settings);
            try (XMLStreamReader reader = XMLInputFactory.newFactory().createXMLStreamReader(new FileInputStream(file));){
                int event;
                String elementName = null;
                while ((event = reader.next()) != 8) {
                    if (event == 1) {
                        elementName = reader.getLocalName();
                        continue;
                    }
                    if (event == 2) {
                        elementName = null;
                        continue;
                    }
                    if (event != 4 || !"localRepository".equals(elementName)) continue;
                    path = reader.getText().trim();
                }
            }
        }
        return path;
    }
}

