/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.URIField;
import org.apache.camel.impl.DefaultEndpointConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationHelper.class);

    private ConfigurationHelper() {
    }

    public static EndpointConfiguration createConfiguration(String uri, CamelContext context) throws Exception {
        int schemeSeparator = uri.indexOf(58);
        if (schemeSeparator == -1) {
            return null;
        }
        String scheme = uri.substring(0, schemeSeparator);
        Component component = context.getComponent(scheme);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Lookup for Component handling \"{}:\" configuration returned {}", new Object[]{scheme, component != null ? component.getClass().getName() : "<null>"});
        }
        if (component != null) {
            EndpointConfiguration config = component.createConfiguration(scheme);
            if (config instanceof DefaultEndpointConfiguration) {
                ((DefaultEndpointConfiguration)config).setURI(uri);
            }
            return config;
        }
        return null;
    }

    public static void populateFromURI(CamelContext camelContext, EndpointConfiguration config, ParameterSetter setter) {
        URI uri = config.getURI();
        setter.set(camelContext, config, "scheme", uri.getScheme());
        setter.set(camelContext, config, "schemeSpecificPart", uri.getSchemeSpecificPart());
        setter.set(camelContext, config, "authority", uri.getAuthority());
        setter.set(camelContext, config, "userInfo", uri.getUserInfo());
        setter.set(camelContext, config, "host", uri.getHost());
        setter.set(camelContext, config, "port", Integer.toString(uri.getPort()));
        setter.set(camelContext, config, "path", uri.getPath());
        setter.set(camelContext, config, "query", uri.getQuery());
        setter.set(camelContext, config, "fragment", uri.getFragment());
        try {
            Map<String, Object> parameters = URISupport.parseParameters(uri);
            for (Map.Entry<String, Object> pair : parameters.entrySet()) {
                setter.set(camelContext, config, pair.getKey(), pair.getValue());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static Field findConfigurationField(EndpointConfiguration config, String name) {
        if (config != null && name != null) {
            Field[] fields;
            Class<?> clazz = config.getClass();
            for (Field field : fields = clazz.getDeclaredFields()) {
                URIField anno = field.getAnnotation(URIField.class);
                if (!(anno == null ? field.getName().equals(name) : anno.component().equals(name) || anno.component().equals("query") && anno.parameter().equals(name))) continue;
                Field found = field;
                LOG.trace("Found field {}.{} as candidate for parameter {}", new Object[]{clazz.getName(), found.getName(), name});
                return found;
            }
        }
        return null;
    }

    public static Object getConfigurationParameter(EndpointConfiguration config, String name) {
        Field field = ConfigurationHelper.findConfigurationField(config, name);
        return ConfigurationHelper.getConfigurationParameter(config, field);
    }

    public static Object getConfigurationParameter(EndpointConfiguration config, Field field) {
        if (field != null) {
            try {
                return IntrospectionSupport.getProperty(config, field.getName());
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Failed to get property '" + field.getName() + "' on " + config + " due " + e.getMessage(), e);
            }
        }
        return null;
    }

    public static <T> void setConfigurationField(CamelContext camelContext, EndpointConfiguration config, String name, T value) {
        Field field = ConfigurationHelper.findConfigurationField(config, name);
        if (field == null) {
            return;
        }
        try {
            IntrospectionSupport.setProperty(camelContext.getTypeConverter(), config, name, value);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to set property '" + name + "' on " + config + " due " + e.getMessage(), e);
        }
    }

    public static class FieldParameterSetter
    implements ParameterSetter {
        @Override
        public <T> void set(CamelContext camelContext, EndpointConfiguration config, String name, T value) {
            ConfigurationHelper.setConfigurationField(camelContext, config, name, value);
        }
    }

    public static interface ParameterSetter {
        public <T> void set(CamelContext var1, EndpointConfiguration var2, String var3, T var4) throws RuntimeCamelException;
    }
}

