/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.perl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.rewriter.JetspeedRewriterController;
import org.apache.jetspeed.rewriter.RewriterController;
import org.apache.jetspeed.rewriter.RewriterException;
import org.apache.jetspeed.rewriter.RulesetRewriter;
import org.apache.jetspeed.rewriter.html.SwingParserAdaptor;
import org.apache.jetspeed.rewriter.rules.Ruleset;
import org.apache.jetspeed.rewriter.xml.SaxParserAdaptor;
import org.apache.portals.bridges.common.ScriptPostProcess;
import org.apache.portals.bridges.perl.PerlContentRewriter;
import org.apache.portals.bridges.perl.PerlParameters;

public class PerlPortlet
extends GenericPortlet {
    public static final String PARAM_PERL_SCRIPT = "PerlScript";
    public static final String PARAM_SCRIPT_PATH = "ScriptPath";
    public static final String PARAM_DEMO_MODE = "DemoMode";
    public static final String PARAM_APPLICATION = "Application";
    private String perlScript = "perl-demo.cgi";
    private String scriptPath = "cgi-bin";
    private String applicationName = null;
    private boolean bDemoMode = false;
    private static final Log log = LogFactory.getLog((Class)PerlPortlet.class);
    private String lastQuery = null;
    String lastPage = null;
    RulesetRewriter rewriter = null;
    RewriterController rewriteController = null;
    public String defaultEncoding = "UTF-8";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.scriptPath = config.getInitParameter(PARAM_SCRIPT_PATH);
        this.perlScript = config.getInitParameter(PARAM_PERL_SCRIPT);
        String demoMode = config.getInitParameter(PARAM_DEMO_MODE);
        this.applicationName = config.getInitParameter(PARAM_APPLICATION);
        if (demoMode != null && demoMode.compareToIgnoreCase("on") == 0) {
            this.bDemoMode = true;
        }
        if (this.scriptPath == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + PARAM_SCRIPT_PATH + " not specified");
        }
        if (this.perlScript == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + PARAM_PERL_SCRIPT + " not specified");
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String perlParameter = actionRequest.getParameter("_PERL");
        if (perlParameter != null && perlParameter.length() > 0) {
            PerlParameters cgi = new PerlParameters();
            cgi.setApplicationName(this.applicationName);
            int ixQuery = perlParameter.indexOf(63);
            if (ixQuery != -1) {
                if (perlParameter.charAt(0) == '/') {
                    cgi.setScriptName(perlParameter.substring(1, ixQuery));
                } else {
                    cgi.setScriptName(perlParameter.substring(0, ixQuery));
                }
                String queryArguments = perlParameter.substring(ixQuery + 1);
                System.out.println("ProcessRequest -- Script " + perlParameter.substring(0, ixQuery) + " Query string " + queryArguments);
                int ixQuerySeparator = queryArguments.indexOf(38);
                while (ixQuerySeparator != -1) {
                    cgi.addQueryArgument(queryArguments.substring(0, ixQuerySeparator));
                    queryArguments = queryArguments.substring(ixQuerySeparator + 1);
                    ixQuerySeparator = queryArguments.indexOf(38);
                }
                cgi.addQueryArgument(queryArguments);
                actionRequest.getPortletSession().setAttribute("PerlParameter", (Object)cgi, 1);
            } else {
                cgi.setScriptName(perlParameter);
                Enumeration names = actionRequest.getParameterNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (name.compareToIgnoreCase("_PERL") == 0) continue;
                    String[] values = actionRequest.getParameterValues(name);
                    for (int ii = 0; ii < values.length; ++ii) {
                        String value = values[ii];
                        if (value == null || value.length() <= 0) continue;
                        value = this.urlEncoding(value, "&", "%26");
                        value = this.urlEncoding(value, "+", "%2b");
                        value = this.urlEncoding(value, "\\", "%5c");
                        cgi.addQueryArgument(name + "=" + value);
                    }
                }
                actionRequest.getPortletSession().setAttribute("PerlParameter", (Object)cgi, 1);
            }
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        HttpServletResponse httpResponse = (HttpServletResponse)((HttpServletResponseWrapper)response).getResponse();
        PrintWriter writer = httpResponse.getWriter();
        String query = null;
        Object scriptName = null;
        PerlParameters perlParam = null;
        try {
            perlParam = (PerlParameters)((Object)request.getPortletSession().getAttribute("PerlParameter", 1));
            request.getPortletSession().removeAttribute("PerlParameter", 1);
        }
        catch (Exception e) {
            perlParam = null;
        }
        if (perlParam != null) {
            if (perlParam.getApplicationName().compareToIgnoreCase(this.applicationName) == 0) {
                query = perlParam.getQueryString();
                this.perlScript = perlParam.getScriptName();
            }
            if (this.applicationName == null) {
                this.applicationName = perlParam.getApplicationName();
            } else if (this.lastPage != null && this.applicationName != null && perlParam.getApplicationName().compareToIgnoreCase(this.applicationName) != 0) {
                writer.println(this.lastPage);
                return;
            }
        } else {
            StringBuffer queries = new StringBuffer();
            Enumeration names = request.getParameterNames();
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] values = request.getParameterValues(name);
                for (int ii = 0; ii < values.length; ++ii) {
                    int ix;
                    String value = values[ii];
                    if (queries.length() > 0) {
                        queries.append("&");
                    }
                    if ((ix = value.indexOf("?")) > -1) {
                        String tmp;
                        value = tmp = value.substring(0, ix) + "&" + value.substring(ix + 1);
                    }
                    if (name.compareToIgnoreCase("file") == 0) {
                        String reminder = "";
                        int ixEnd = value.indexOf("&");
                        if (ixEnd > -1) {
                            reminder = value.substring(ixEnd + 1);
                            this.perlScript = value.substring(0, ixEnd);
                        } else {
                            this.perlScript = value;
                        }
                        if (reminder.length() <= 0) continue;
                        queries.append(reminder);
                        continue;
                    }
                    queries.append(name).append("=").append(value);
                }
            }
            query = queries.toString();
            queries.delete(0, queries.length());
            System.out.println("Script [" + this.perlScript + "]");
            System.out.println("Direct Query [" + queries.toString() + "]");
        }
        String perlExecutable = null;
        PortletContext portletApplication = this.getPortletContext();
        String path = portletApplication.getRealPath("/WEB-INF");
        String contextPath = path + "/";
        String fullScriptPath = contextPath + this.scriptPath;
        if (!this.perlScript.startsWith("/")) {
            fullScriptPath = fullScriptPath + "/";
        }
        fullScriptPath = fullScriptPath + this.perlScript;
        String command = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fullScriptPath));
            String lnExecutable = in.readLine();
            if (lnExecutable != null) {
                String lnExecutableLower = lnExecutable.toLowerCase();
                int px = lnExecutableLower.indexOf("perl");
                int ix = lnExecutable.indexOf(33);
                if (ix != -1 && px != -1) {
                    int ex = lnExecutable.indexOf(32, ix);
                    perlExecutable = ex >= 0 ? lnExecutable.substring(ix + 1, ex) : lnExecutable.substring(ix + 1);
                }
            }
            in.close();
            StringBuffer commandBuffer = new StringBuffer();
            if (perlExecutable == null) {
                commandBuffer.append(fullScriptPath);
            } else {
                commandBuffer.append(perlExecutable).append(' ').append(fullScriptPath);
            }
            command = new String(commandBuffer.toString());
        }
        catch (FileNotFoundException e) {
            writer.println("<P><B>File doesn't exist (" + fullScriptPath + ")</B></P>");
        }
        catch (IOException e) {
            writer.println("<P><B>IO Exception (" + e.getMessage() + ")</B></P>");
        }
        catch (Exception e) {
            writer.println("<P><B>IO Exception (" + e.getMessage() + ")</B></P>");
        }
        String envQuery = "QUERY_STRING=" + query;
        String[] env = null;
        env = new String[]{"REQUEST_METHOD=GET", envQuery, "LD_LIBRARY_PATH=/usr/local/groundwork/lib"};
        if (this.bDemoMode) {
            writer.println("<B><P>Perl Script:</B>" + fullScriptPath + "<BR>");
            writer.println("<B>Query String:</B>" + query + "</P>");
        }
        if (command != null) {
            try {
                long timeStart = 0L;
                long timeEnd = 0L;
                if (this.bDemoMode) {
                    timeStart = System.currentTimeMillis();
                }
                Process proc = Runtime.getRuntime().exec(command, env);
                InputStream in = proc.getInputStream();
                BufferedReader perlResult = new BufferedReader(new InputStreamReader(in));
                StringBuffer page = new StringBuffer();
                if (this.bDemoMode) {
                    timeEnd = System.currentTimeMillis();
                    writer.println("<B>Execution Time create process: </B>" + (timeEnd - timeStart) + " ms </P>");
                    timeStart = System.currentTimeMillis();
                }
                int BLOCK_SIZE = 8192;
                char[] bytes = new char[BLOCK_SIZE];
                boolean bProcDone = false;
                while (!bProcDone) {
                    try {
                        proc.exitValue();
                        bProcDone = true;
                    }
                    catch (IllegalThreadStateException e) {
                        bProcDone = false;
                        int len = perlResult.read(bytes, 0, BLOCK_SIZE);
                        while (len > 0) {
                            page.append(bytes, 0, len);
                            len = perlResult.read(bytes, 0, BLOCK_SIZE);
                        }
                    }
                }
                int len = perlResult.read(bytes, 0, BLOCK_SIZE);
                while (len > 0) {
                    page.append(bytes, 0, len);
                    len = perlResult.read(bytes, 0, BLOCK_SIZE);
                }
                perlResult.close();
                try {
                    proc.destroy();
                }
                catch (Exception e) {
                    System.out.println("Error killing perl subprocess. Error " + e);
                }
                if (this.bDemoMode) {
                    timeEnd = System.currentTimeMillis();
                    writer.println("<B>Loading output of perl: </B>" + (timeEnd - timeStart) + " ms </P>");
                    timeStart = System.currentTimeMillis();
                }
                PortletURL actionURL = response.createActionURL();
                ScriptPostProcess processor = new ScriptPostProcess();
                processor.setInitalPage(page);
                processor.postProcessPage(actionURL, "_PERL");
                String finalPage = processor.getFinalizedPage();
                if (this.bDemoMode) {
                    timeEnd = System.currentTimeMillis();
                    writer.println("<P><B>Rewriting perl: </B>" + (timeEnd - timeStart) + " ms </P>");
                }
                writer.println(finalPage);
            }
            catch (IOException ioe) {
                writer.println("<P><B>Exception while reading perl output" + ioe.getMessage() + "</B></P>");
            }
            catch (Exception e) {
                writer.println("<P><B>Exception while reading perl output" + e + "</B></P>");
            }
        } else {
            writer.println("<P><B>Error. Failed to run perl script [" + this.perlScript + "]</B></P>");
        }
    }

    private RewriterController getController(String contextPath) throws Exception {
        Class[] rewriterClasses = new Class[]{PerlContentRewriter.class, PerlContentRewriter.class};
        Class[] adaptorClasses = new Class[]{SwingParserAdaptor.class, SaxParserAdaptor.class};
        JetspeedRewriterController rwc = new JetspeedRewriterController(contextPath + "conf/rewriter-rules-mapping.xml", Arrays.asList(rewriterClasses), Arrays.asList(adaptorClasses));
        FileReader reader = new FileReader(contextPath + "conf/default-rewriter-rules.xml");
        Ruleset ruleset = rwc.loadRuleset((Reader)reader);
        reader.close();
        this.rewriter = rwc.createRewriter(ruleset);
        return rwc;
    }

    protected byte[] doWebContent(StringBuffer perlRenderedPage, PortletURL actionURL, String actionParameterName) throws PortletException {
        OutputStreamWriter htmlWriter = null;
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try {
            htmlWriter = new OutputStreamWriter((OutputStream)byteOutputStream, this.defaultEncoding);
            ((PerlContentRewriter)this.rewriter).setActionURL(actionURL);
            ((PerlContentRewriter)this.rewriter).setActionParameterName(actionParameterName);
            StringReader perlReader = new StringReader(perlRenderedPage.toString());
            this.rewriter.rewrite(this.rewriteController.createParserAdaptor("text/html"), (Reader)perlReader, (Writer)htmlWriter);
            ((Writer)htmlWriter).flush();
        }
        catch (UnsupportedEncodingException ueex) {
            throw new PortletException("Encoding " + this.defaultEncoding + " not supported. Error: " + ueex.getMessage());
        }
        catch (RewriterException rwe) {
            throw new PortletException("Failed to rewrite Perl ouput. Error: " + rwe.getMessage());
        }
        catch (Exception e) {
            throw new PortletException("Exception while rewritting Perl output. Error: " + e.getMessage());
        }
        return byteOutputStream.toByteArray();
    }

    private String urlEncoding(String url, String source, String replace) {
        String value = url;
        int ix = value.indexOf(source);
        if (ix != -1) {
            String replacement = "";
            while (ix != -1) {
                replacement = replacement + value.substring(0, ix);
                replacement = replacement + replace;
                value = value.length() > ix ? value.substring(ix + 1) : "";
                ix = value.indexOf(source);
            }
            value = replacement = replacement + value;
        }
        return value;
    }
}

