/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.jsf;

import java.io.IOException;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.jsf.PortletUIViewRoot;

public class PortletViewHandlerImpl
extends ViewHandler {
    private static final Log log = LogFactory.getLog(PortletViewHandlerImpl.class);
    private ViewHandler handler;

    public PortletViewHandlerImpl(ViewHandler handler) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Delegating to " + handler + ""));
        }
        this.handler = handler;
    }

    public Locale calculateLocale(FacesContext facesContext) {
        return this.handler.calculateLocale(facesContext);
    }

    public String calculateRenderKitId(FacesContext facesContext) {
        return this.handler.calculateRenderKitId(facesContext);
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        PortletUIViewRoot portletViewRoot = null;
        UIViewRoot root = this.handler.createView(facesContext, viewId);
        if (root != null) {
            portletViewRoot = root instanceof PortletUIViewRoot ? (PortletUIViewRoot)root : new PortletUIViewRoot(root);
            facesContext.setViewRoot((UIViewRoot)portletViewRoot);
        }
        return portletViewRoot;
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        Object response = facesContext.getExternalContext().getResponse();
        if (!(response instanceof RenderResponse)) {
            throw new IllegalStateException("Must be a RenderResponse");
        }
        RenderResponse renderResponse = (RenderResponse)response;
        PortletURL actionURL = renderResponse.createActionURL();
        return actionURL.toString();
    }

    public String getResourceURL(FacesContext facesContext, String path) {
        return this.handler.getResourceURL(facesContext, path);
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException, FacesException {
        this.handler.renderView(facesContext, viewToRender);
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        PortletUIViewRoot portletViewRoot = null;
        UIViewRoot root = this.handler.restoreView(facesContext, viewId);
        if (root != null) {
            portletViewRoot = root instanceof PortletUIViewRoot ? (PortletUIViewRoot)root : new PortletUIViewRoot(root);
            facesContext.setViewRoot((UIViewRoot)portletViewRoot);
        }
        return portletViewRoot;
    }

    public void writeState(FacesContext facesContext) throws IOException {
        this.handler.writeState(facesContext);
    }
}

