/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.demo.simple;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.portals.bridges.common.GenericServletPortlet;

public class PickANumberPortlet
extends GenericServletPortlet {
    private static final PortletMode ABOUT_MODE = new PortletMode("about");
    private static final PortletMode EDIT_DEFAULTS_MODE = new PortletMode("edit_defaults");
    private static final PortletMode PREVIEW_MODE = new PortletMode("preview");
    private static final PortletMode PRINT_MODE = new PortletMode("print");
    private static final String DEFAULT_ACTION_PAGE = null;
    private static final String DEFAULT_CUSTOM_PAGE = null;
    private static final String DEFAULT_EDIT_PAGE = "/WEB-INF/demo/simple/PickANumberEdit.jsp";
    private static final String DEFAULT_HELP_PAGE = "/WEB-INF/demo/simple/PickANumberHelp.jsp";
    private static final String DEFAULT_VIEW_PAGE = "/WEB-INF/demo/simple/PickANumber.jsp";
    private static final String DEFAULT_ABOUT_PAGE = "/WEB-INF/demo/simple/PickANumberAbout.jsp";
    private static final String DEFAULT_EDIT_DEFAULTS_PAGE = "/WEB-INF/demo/simple/PickANumberEditDefaults.jsp";
    private static final String GUESS_COUNT_NAME = "GuessCount";
    private static final String GUESS_PARAMETER_NAME = "Guess";
    private static final String LAST_GUESS_NAME = "LastGuess";
    private static final String TARGET_VALUE_NAME = "TargetValue";
    private static final String TOP_RANGE_NAME = "TopRange";

    public PickANumberPortlet() {
        this.setDefaultActionPage(DEFAULT_ACTION_PAGE);
        this.setDefaultCustomPage(DEFAULT_CUSTOM_PAGE);
        this.setDefaultEditPage(DEFAULT_EDIT_PAGE);
        this.setDefaultHelpPage(DEFAULT_HELP_PAGE);
        this.setDefaultViewPage(DEFAULT_VIEW_PAGE);
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (!request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            PortletMode curMode = request.getPortletMode();
            if (PRINT_MODE.equals((Object)curMode)) {
                this.doView(request, response);
            } else if (ABOUT_MODE.equals((Object)curMode)) {
                request.setAttribute("ViewPage", (Object)DEFAULT_ABOUT_PAGE);
                this.doView(request, response);
            } else if (EDIT_DEFAULTS_MODE.equals((Object)curMode)) {
                request.setAttribute("EditPage", (Object)DEFAULT_EDIT_DEFAULTS_PAGE);
                this.doEdit(request, response);
            } else if (PREVIEW_MODE.equals((Object)curMode)) {
                response.setContentType("text/html");
                response.getWriter().println("<img src=\"" + request.getContextPath() + "/images/preview/pickanumber.png" + "\"/>");
            } else {
                super.doDispatch(request, response);
            }
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Long highRange;
        PortletSession session = request.getPortletSession();
        Long guessCount = null;
        Long targetValue = null;
        long range = this.getHighRange((PortletRequest)request);
        targetValue = (Long)session.getAttribute(TARGET_VALUE_NAME, 1);
        if (targetValue == null) {
            targetValue = new Long(Math.round(Math.random() * (double)range));
            guessCount = new Long(0L);
            session.setAttribute(TARGET_VALUE_NAME, (Object)targetValue, 1);
            long highRange2 = this.getHighRange((PortletRequest)request);
            session.setAttribute(TOP_RANGE_NAME, (Object)new Long(highRange2), 1);
        }
        if ((guessCount = (Long)session.getAttribute(GUESS_COUNT_NAME, 1)) == null) {
            guessCount = new Long(0L);
            session.setAttribute(GUESS_COUNT_NAME, (Object)guessCount, 1);
        }
        if ((highRange = (Long)session.getAttribute(TOP_RANGE_NAME, 1)) == null || highRange != range) {
            session.setAttribute(TOP_RANGE_NAME, (Object)new Long(range), 1);
        }
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        if (this.isEditAction(request)) {
            this.savePreferences((PortletRequest)request);
            return;
        }
        if (request.getParameter("redirect-test") != null) {
            actionResponse.sendRedirect("/jetspeed/desktop/rss.psml");
            return;
        }
        Long guessCount = null;
        Long targetValue = null;
        Long currentGuess = null;
        Long lastGuess = null;
        PortletSession session = request.getPortletSession();
        lastGuess = (Long)session.getAttribute(LAST_GUESS_NAME, 1);
        targetValue = (Long)session.getAttribute(TARGET_VALUE_NAME, 1);
        if (targetValue != null && lastGuess != null && targetValue.equals(lastGuess)) {
            targetValue = null;
        }
        if (targetValue == null) {
            long random = Math.round(Math.random() * (double)this.getHighRange((PortletRequest)request));
            if (random == 0L) {
                random = 1L;
            }
            targetValue = new Long(random);
            guessCount = new Long(0L);
            session.setAttribute(TARGET_VALUE_NAME, (Object)targetValue, 1);
        }
        if (guessCount == null && (guessCount = (Long)session.getAttribute(GUESS_COUNT_NAME, 1)) == null) {
            guessCount = new Long(0L);
        }
        guessCount = new Long(guessCount + 1L);
        try {
            String result = request.getParameter(GUESS_PARAMETER_NAME);
            if (result != null) {
                currentGuess = new Long(result);
            }
        }
        catch (Exception e) {
            currentGuess = new Long(0L);
        }
        session.setAttribute(GUESS_COUNT_NAME, (Object)guessCount, 1);
        session.setAttribute(LAST_GUESS_NAME, (Object)currentGuess, 1);
    }

    private long getHighRange(PortletRequest request) {
        PortletPreferences prefs = request.getPreferences();
        String highRangePref = prefs.getValue(TOP_RANGE_NAME, "102");
        long range = Long.parseLong(highRangePref);
        if (range < 2L) {
            range = 102L;
        }
        return range;
    }

    private boolean isEditAction(ActionRequest request) {
        return request.getParameter(TOP_RANGE_NAME) != null;
    }

    private void savePreferences(PortletRequest request) {
        String topRange = request.getParameter(TOP_RANGE_NAME);
        long range = Long.parseLong(topRange);
        if (range < 2L) {
            return;
        }
        PortletPreferences prefs = request.getPreferences();
        try {
            prefs.setValue(TOP_RANGE_NAME, topRange);
            prefs.store();
            PortletSession session = request.getPortletSession();
            session.setAttribute(TOP_RANGE_NAME, (Object)new Long(range), 1);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

