/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.BasicControlDecorator;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.IntermediateOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.api.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.api.ldap.codec.controls.proxiedauthz.ProxiedAuthzFactory;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.api.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseFactory;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.OpaqueExtendedRequest;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapCodecService
implements LdapApiService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLdapCodecService.class);
    private Map<String, ControlFactory<? extends Control>> requestControlFactories = new HashMap<String, ControlFactory<? extends Control>>();
    private Map<String, ControlFactory<? extends Control>> responseControlFactories = new HashMap<String, ControlFactory<? extends Control>>();
    private Map<String, ExtendedOperationFactory> extendedRequestFactories = new HashMap<String, ExtendedOperationFactory>();
    private Map<String, ExtendedOperationFactory> extendedResponseFactories = new HashMap<String, ExtendedOperationFactory>();
    private Map<String, IntermediateOperationFactory> intermediateResponseFactories = new HashMap<String, IntermediateOperationFactory>();
    private ProtocolCodecFactory protocolCodecFactory;

    public DefaultLdapCodecService() {
        this.loadStockControls();
    }

    private void loadStockControls() {
        CascadeFactory cascadeFactory = new CascadeFactory(this);
        this.requestControlFactories.put(cascadeFactory.getOid(), cascadeFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, cascadeFactory.getOid()));
        }
        EntryChangeFactory entryChangeFactory = new EntryChangeFactory(this);
        this.responseControlFactories.put(entryChangeFactory.getOid(), entryChangeFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, entryChangeFactory.getOid()));
        }
        ManageDsaITFactory manageDsaItFactory = new ManageDsaITFactory(this);
        this.requestControlFactories.put(manageDsaItFactory.getOid(), manageDsaItFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, manageDsaItFactory.getOid()));
        }
        PagedResultsFactory pageResultsFactory = new PagedResultsFactory(this);
        this.requestControlFactories.put(pageResultsFactory.getOid(), pageResultsFactory);
        this.responseControlFactories.put(pageResultsFactory.getOid(), pageResultsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, pageResultsFactory.getOid()));
        }
        PersistentSearchFactory persistentSearchFactory = new PersistentSearchFactory(this);
        this.requestControlFactories.put(persistentSearchFactory.getOid(), persistentSearchFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, persistentSearchFactory.getOid()));
        }
        ProxiedAuthzFactory proxiedAuthzFactory = new ProxiedAuthzFactory(this);
        this.requestControlFactories.put(proxiedAuthzFactory.getOid(), proxiedAuthzFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, proxiedAuthzFactory.getOid()));
        }
        SortRequestFactory sortRequestFactory = new SortRequestFactory(this);
        this.requestControlFactories.put(sortRequestFactory.getOid(), sortRequestFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, sortRequestFactory.getOid()));
        }
        SortResponseFactory sortResponseFactory = new SortResponseFactory(this);
        this.responseControlFactories.put(sortResponseFactory.getOid(), sortResponseFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, sortResponseFactory.getOid()));
        }
        SubentriesFactory subentriesFactory = new SubentriesFactory(this);
        this.requestControlFactories.put(subentriesFactory.getOid(), subentriesFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, subentriesFactory.getOid()));
        }
    }

    @Override
    public ControlFactory<?> registerRequestControl(ControlFactory<?> factory) {
        return this.requestControlFactories.put(factory.getOid(), factory);
    }

    @Override
    public ControlFactory<?> registerResponseControl(ControlFactory<?> factory) {
        return this.responseControlFactories.put(factory.getOid(), factory);
    }

    @Override
    public ControlFactory<?> unregisterRequestControl(String oid) {
        return this.requestControlFactories.remove(oid);
    }

    @Override
    public ControlFactory<?> unregisterResponseControl(String oid) {
        return this.responseControlFactories.remove(oid);
    }

    @Override
    public Iterator<String> registeredRequestControls() {
        return Collections.unmodifiableSet(this.requestControlFactories.keySet()).iterator();
    }

    @Override
    public Iterator<String> registeredResponseControls() {
        return Collections.unmodifiableSet(this.responseControlFactories.keySet()).iterator();
    }

    @Override
    public boolean isControlRegistered(String oid) {
        return this.requestControlFactories.containsKey(oid) || this.responseControlFactories.containsKey(oid);
    }

    @Override
    public Iterator<String> registeredExtendedRequests() {
        return Collections.unmodifiableSet(this.extendedRequestFactories.keySet()).iterator();
    }

    @Override
    public Iterator<String> registeredExtendedResponses() {
        return Collections.unmodifiableSet(this.extendedResponseFactories.keySet()).iterator();
    }

    @Override
    public ExtendedOperationFactory registerExtendedRequest(ExtendedOperationFactory factory) {
        return this.extendedRequestFactories.put(factory.getOid(), factory);
    }

    @Override
    public ExtendedOperationFactory registerExtendedResponse(ExtendedOperationFactory factory) {
        return this.extendedResponseFactories.put(factory.getOid(), factory);
    }

    @Override
    public Iterator<String> registeredIntermediateResponses() {
        return Collections.unmodifiableSet(this.intermediateResponseFactories.keySet()).iterator();
    }

    @Override
    public IntermediateOperationFactory registerIntermediateResponse(IntermediateOperationFactory factory) {
        return this.intermediateResponseFactories.put(factory.getOid(), factory);
    }

    @Override
    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.protocolCodecFactory;
    }

    @Override
    public ProtocolCodecFactory registerProtocolCodecFactory(ProtocolCodecFactory protocolCodecFactory) {
        ProtocolCodecFactory oldFactory = this.protocolCodecFactory;
        this.protocolCodecFactory = protocolCodecFactory;
        return oldFactory;
    }

    @Override
    public javax.naming.ldap.Control toJndiControl(Control control) throws EncoderException {
        ControlFactory<? extends Control> factory = this.requestControlFactories.get(control.getOid());
        if (factory == null) {
            if (control instanceof OpaqueControl) {
                return new BasicControl(control.getOid(), control.isCritical(), ((OpaqueControl)control).getEncodedValue());
            }
            return new BasicControl(control.getOid(), control.isCritical(), null);
        }
        Asn1Buffer asn1Buffer = new Asn1Buffer();
        factory.encodeValue(asn1Buffer, control);
        return new BasicControl(control.getOid(), control.isCritical(), asn1Buffer.getBytes().array());
    }

    @Override
    public Control fromJndiRequestControl(javax.naming.ldap.Control control) throws DecoderException {
        ControlFactory<? extends Control> factory = this.requestControlFactories.get(control.getID());
        if (factory == null) {
            OpaqueControl ourControl = new OpaqueControl(control.getID());
            ourControl.setCritical(control.isCritical());
            BasicControlDecorator decorator = new BasicControlDecorator((LdapApiService)this, ourControl);
            decorator.setValue(control.getEncodedValue());
            return decorator;
        }
        Control ourControl = factory.newControl();
        ourControl.setCritical(control.isCritical());
        factory.decodeValue(ourControl, control.getEncodedValue());
        return ourControl;
    }

    @Override
    public Control fromJndiResponseControl(javax.naming.ldap.Control control) throws DecoderException {
        ControlFactory<? extends Control> factory = this.responseControlFactories.get(control.getID());
        if (factory == null) {
            OpaqueControl ourControl = new OpaqueControl(control.getID());
            ourControl.setCritical(control.isCritical());
            BasicControlDecorator decorator = new BasicControlDecorator((LdapApiService)this, ourControl);
            decorator.setValue(control.getEncodedValue());
            return decorator;
        }
        Control ourControl = factory.newControl();
        ourControl.setCritical(control.isCritical());
        factory.decodeValue(ourControl, control.getEncodedValue());
        return ourControl;
    }

    @Override
    public ExtendedOperationFactory unregisterExtendedRequest(String oid) {
        return this.extendedRequestFactories.remove(oid);
    }

    @Override
    public ExtendedOperationFactory unregisterExtendedResponse(String oid) {
        return this.extendedResponseFactories.remove(oid);
    }

    @Override
    public IntermediateOperationFactory unregisterIntermediateResponse(String oid) {
        return this.intermediateResponseFactories.remove(oid);
    }

    @Override
    public ExtendedResponse toJndi(org.apache.directory.api.ldap.model.message.ExtendedResponse modelResponse) throws EncoderException {
        throw new NotImplementedException(I18n.err(I18n.ERR_05401_FIGURE_OUT_HOW_TO_TRANSFORM, new Object[0]));
    }

    @Override
    public org.apache.directory.api.ldap.model.message.ExtendedResponse fromJndi(ExtendedResponse jndiResponse) throws DecoderException {
        throw new NotImplementedException(I18n.err(I18n.ERR_05401_FIGURE_OUT_HOW_TO_TRANSFORM, new Object[0]));
    }

    @Override
    public org.apache.directory.api.ldap.model.message.ExtendedRequest fromJndi(ExtendedRequest jndiRequest) throws DecoderException {
        ExtendedOperationFactory extendedRequestFactory = this.extendedRequestFactories.get(jndiRequest.getID());
        if (extendedRequestFactory != null) {
            return extendedRequestFactory.newRequest(jndiRequest.getEncodedValue());
        }
        return new OpaqueExtendedRequest(jndiRequest.getID(), jndiRequest.getEncodedValue());
    }

    @Override
    public ExtendedRequest toJndi(final org.apache.directory.api.ldap.model.message.ExtendedRequest modelRequest) throws EncoderException {
        final String oid = modelRequest.getRequestName();
        ExtendedOperationFactory extendedRequestFactory = this.extendedRequestFactories.get(modelRequest.getRequestName());
        Asn1Buffer asn1Buffer = new Asn1Buffer();
        extendedRequestFactory.encodeValue(asn1Buffer, modelRequest);
        final byte[] value = asn1Buffer.getBytes().array();
        return new ExtendedRequest(){
            private static final long serialVersionUID = -4160980385909987475L;

            @Override
            public String getID() {
                return oid;
            }

            @Override
            public byte[] getEncodedValue() {
                return value;
            }

            @Override
            public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
                final ExtendedOperationFactory factory = (ExtendedOperationFactory)DefaultLdapCodecService.this.extendedResponseFactories.get(modelRequest.getRequestName());
                try {
                    final org.apache.directory.api.ldap.model.message.ExtendedResponse resp = factory.newResponse(berValue);
                    return new ExtendedResponse(){
                        private static final long serialVersionUID = -7686354122066100703L;

                        @Override
                        public String getID() {
                            return oid;
                        }

                        @Override
                        public byte[] getEncodedValue() {
                            Asn1Buffer asn1Buffer = new Asn1Buffer();
                            factory.encodeValue(asn1Buffer, resp);
                            return asn1Buffer.getBytes().array();
                        }
                    };
                }
                catch (DecoderException de) {
                    NamingException ne = new NamingException(I18n.err(I18n.ERR_05402_UNABLE_TO_ENCODE_RESPONSE_VALUE, Strings.dumpBytes(berValue)));
                    ne.setRootCause(de);
                    throw ne;
                }
            }
        };
    }

    @Override
    public boolean isExtendedRequestRegistered(String oid) {
        return this.extendedRequestFactories.containsKey(oid);
    }

    @Override
    public boolean isExtendedResponseRegistered(String oid) {
        return this.extendedResponseFactories.containsKey(oid);
    }

    @Override
    public boolean isIntermediateResponseRegistered(String oid) {
        return this.intermediateResponseFactories.containsKey(oid);
    }

    @Override
    public Map<String, ControlFactory<? extends Control>> getRequestControlFactories() {
        return this.requestControlFactories;
    }

    @Override
    public Map<String, ControlFactory<? extends Control>> getResponseControlFactories() {
        return this.responseControlFactories;
    }

    public void setRequestControlFactories(Map<String, ControlFactory<? extends Control>> requestControlFactories) {
        this.requestControlFactories = requestControlFactories;
    }

    public void setResponseControlFactories(Map<String, ControlFactory<? extends Control>> responseControlFactories) {
        this.responseControlFactories = responseControlFactories;
    }

    @Override
    public Map<String, ExtendedOperationFactory> getExtendedRequestFactories() {
        return this.extendedRequestFactories;
    }

    @Override
    public Map<String, ExtendedOperationFactory> getExtendedResponseFactories() {
        return this.extendedResponseFactories;
    }

    @Override
    public Map<String, IntermediateOperationFactory> getIntermediateResponseFactories() {
        return this.intermediateResponseFactories;
    }

    public void setExtendedRequestFactories(Map<String, ExtendedOperationFactory> extendedOperationFactories) {
        this.extendedRequestFactories = extendedOperationFactories;
    }

    public void setExtendedResponseFactories(Map<String, ExtendedOperationFactory> extendedOperationFactories) {
        this.extendedResponseFactories = extendedOperationFactories;
    }

    public void setIntermediateResponseFactories(Map<String, IntermediateOperationFactory> intermediateResponseFactories) {
        this.intermediateResponseFactories = intermediateResponseFactories;
    }

    public void setProtocolCodecFactory(ProtocolCodecFactory protocolCodecFactory) {
        this.protocolCodecFactory = protocolCodecFactory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Request controls       :\n");
        for (Map.Entry<String, ControlFactory<? extends Control>> entry : this.requestControlFactories.entrySet()) {
            sb.append("    ");
            sb.append(entry.getValue().getClass().getSimpleName());
            sb.append("[").append(entry.getKey()).append("]\n");
        }
        sb.append("Response controls      :\n");
        for (Map.Entry<String, ControlFactory<? extends Control>> entry : this.responseControlFactories.entrySet()) {
            sb.append("    ");
            sb.append(entry.getValue().getClass().getSimpleName());
            sb.append("[").append(entry.getKey()).append("]\n");
        }
        sb.append("Extended requests      :\n");
        for (Map.Entry<String, Object> entry : this.extendedRequestFactories.entrySet()) {
            sb.append("    ");
            sb.append(((ExtendedOperationFactory)entry.getValue()).getClass().getSimpleName());
            sb.append("[").append(entry.getKey()).append("]\n");
        }
        sb.append("Extended responses     :\n");
        for (Map.Entry<String, Object> entry : this.extendedResponseFactories.entrySet()) {
            sb.append("    ");
            sb.append(((ExtendedOperationFactory)entry.getValue()).getClass().getSimpleName());
            sb.append("[").append(entry.getKey()).append("]\n");
        }
        sb.append("Intermediate responses :\n");
        for (Map.Entry<String, Object> entry : this.intermediateResponseFactories.entrySet()) {
            sb.append("    ");
            sb.append(((IntermediateOperationFactory)entry.getValue()).getClass().getSimpleName());
            sb.append("[").append(entry.getKey()).append("]\n");
        }
        return sb.toString();
    }
}

