/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.request;

import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.dsmlv2.ParserUtils;
import org.apache.directory.api.dsmlv2.request.AbstractResultResponseRequestDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ExtendedRequestDsml<Q extends ExtendedRequest, P extends ExtendedResponse>
extends AbstractResultResponseRequestDsml<Q, P>
implements ExtendedRequest {
    private byte[] requestValue;

    public ExtendedRequestDsml(LdapApiService codec, Q ldapMessage) {
        super(codec, ldapMessage);
    }

    @Override
    public MessageTypeEnum getType() {
        return ((ExtendedRequest)this.getDecorated()).getType();
    }

    @Override
    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        if (((ExtendedRequest)this.getDecorated()).getRequestName() != null) {
            element.addElement("requestName").setText(((ExtendedRequest)this.getDecorated()).getRequestName());
        }
        Namespace xsdNamespace = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.getDocument().getRootElement().add(xsdNamespace);
        element.getDocument().getRootElement().add(xsiNamespace);
        Element valueElement = element.addElement("requestValue").addText(ParserUtils.base64Encode(this.getRequestValue()));
        valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
        return element;
    }

    @Override
    public String getRequestName() {
        return ((ExtendedRequest)this.getDecorated()).getRequestName();
    }

    public void setRequestName(Oid requestName) {
        ((ExtendedRequest)this.getDecorated()).setRequestName(requestName.toString());
    }

    public byte[] getRequestValue() {
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        this.requestValue = requestValue;
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return ((ExtendedRequest)this.getDecorated()).getResponseType();
    }

    @Override
    public ExtendedRequest setRequestName(String oid) {
        ((ExtendedRequest)this.getDecorated()).setRequestName(oid);
        return this;
    }

    @Override
    public ExtendedRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public ExtendedRequest addControl(Control control) {
        return (ExtendedRequest)super.addControl(control);
    }

    @Override
    public ExtendedRequest addAllControls(Control[] controls) {
        return (ExtendedRequest)super.addAllControls(controls);
    }

    @Override
    public ExtendedRequest removeControl(Control control) {
        return (ExtendedRequest)super.removeControl(control);
    }
}

